/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBlock;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.core.IngredientPredicateBlockOperator;
import org.cyclops.integratedtunnels.core.ItemStorageBlockWrapper;
import org.cyclops.integratedtunnels.core.TunnelHelpers;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicate;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicateBlockList;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicateItemStackList;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicateItemStackNbt;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicateItemStackOperator;
import org.cyclops.integratedtunnels.part.aspect.ITunnelConnection;

public class TunnelItemHelpers {
    public static final IngredientPredicate<ItemStack, Integer> MATCH_NONE = new IngredientPredicate<ItemStack, Integer>(IngredientComponent.ITEMSTACK, ItemStack.field_190927_a, Integer.valueOf(15), false, true, 0, false){

        @Override
        public boolean test(@Nullable ItemStack input) {
            return false;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == MATCH_NONE;
        }

        @Override
        public int hashCode() {
            return 9991029;
        }
    };

    public static IngredientPredicate<ItemStack, Integer> matchAll(int amount, boolean exactAmount) {
        return new IngredientPredicate<ItemStack, Integer>(IngredientComponent.ITEMSTACK, new ItemStack(Items.field_151034_e, amount), Integer.valueOf(exactAmount ? 8 : 0), false, false, amount, exactAmount){

            @Override
            public boolean test(ItemStack input) {
                return true;
            }
        };
    }

    public static IngredientPredicate<ItemStack, Integer> matchItemStack(final ItemStack itemStack, boolean checkItem, final boolean checkStackSize, final boolean checkDamage, final boolean checkNbt, final boolean blacklist, boolean exactAmount) {
        int matchFlags = 0;
        if (checkItem) {
            matchFlags |= 1;
        }
        if (checkDamage) {
            matchFlags |= 2;
        }
        if (checkNbt) {
            matchFlags |= 4;
        }
        if (checkStackSize) {
            matchFlags |= 8;
        }
        return new IngredientPredicate<ItemStack, Integer>(IngredientComponent.ITEMSTACK, itemStack.func_77946_l(), Integer.valueOf(matchFlags), blacklist, itemStack.func_190926_b() && !blacklist, itemStack.func_190916_E(), exactAmount){

            @Override
            public boolean test(@Nullable ItemStack input) {
                boolean result = TunnelItemHelpers.areItemStackEqual(input, itemStack, checkStackSize, true, checkDamage, checkNbt);
                if (blacklist) {
                    result = !result;
                }
                return result;
            }
        };
    }

    public static IngredientPredicate<ItemStack, Integer> matchItemStacks(IValueTypeListProxy<ValueObjectTypeItemStack, ValueObjectTypeItemStack.ValueItemStack> itemStacks, boolean checkItem, boolean checkStackSize, boolean checkDamage, boolean checkNbt, boolean blacklist, int amount, boolean exactAmount) {
        return new IngredientPredicateItemStackList(blacklist, amount, exactAmount, itemStacks, checkStackSize, checkItem, checkDamage, checkNbt);
    }

    public static IngredientPredicate<ItemStack, Integer> matchPredicateItem(PartTarget partTarget, IOperator predicate, int amount, boolean exactAmount) {
        return new IngredientPredicateItemStackOperator(amount, exactAmount, predicate, partTarget);
    }

    public static IngredientPredicate<ItemStack, Integer> matchBlocks(IValueTypeListProxy<ValueObjectTypeBlock, ValueObjectTypeBlock.ValueBlock> blocks, boolean checkItem, boolean checkStackSize, boolean checkDamage, boolean checkNbt, boolean blacklist, int amount, boolean exactAmount) {
        return new IngredientPredicateBlockList(blacklist, amount, exactAmount, blocks, checkStackSize, checkItem, checkDamage, checkNbt);
    }

    public static IngredientPredicate<ItemStack, Integer> matchPredicateBlock(PartTarget partTarget, IOperator predicate, int amount, boolean exactAmount) {
        return new IngredientPredicateBlockOperator(amount, exactAmount, predicate, partTarget);
    }

    public static IngredientPredicate<ItemStack, Integer> matchNbt(NBTTagCompound tag, boolean subset, boolean superset, boolean requireNbt, boolean recursive, boolean blacklist, int amount, boolean exactAmount) {
        return new IngredientPredicateItemStackNbt(blacklist, amount, exactAmount, requireNbt, subset, tag, recursive, superset);
    }

    public static boolean areItemStackEqual(ItemStack stackA, ItemStack stackB, boolean checkStackSize, boolean checkItem, boolean checkDamage, boolean checkNbt) {
        if (stackA == null && stackB == null) {
            return true;
        }
        if (stackA != null && stackB != null) {
            if (checkStackSize && stackA.func_190916_E() != stackB.func_190916_E()) {
                return false;
            }
            if (checkItem && stackA.func_77973_b() != stackB.func_77973_b()) {
                return false;
            }
            if (checkDamage && stackA.func_77952_i() != stackB.func_77952_i()) {
                return false;
            }
            return !checkNbt || ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
        }
        return false;
    }

    public static ItemStack placeItems(INetwork network, IPositionedAddonsNetworkIngredients<ItemStack, Integer> ingredientsNetwork, int channel, ITunnelConnection connection, IIngredientComponentStorage<ItemStack, Integer> source, World world, BlockPos pos, EnumFacing side, IngredientPredicate<ItemStack, Integer> itemStackMatcher, EnumHand hand, boolean blockUpdate, boolean ignoreReplacable, boolean craftIfFailed) throws EvaluationException {
        IBlockState destBlockState = world.func_180495_p(pos);
        Material destMaterial = destBlockState.func_185904_a();
        boolean isDestNonSolid = !destMaterial.func_76220_a();
        boolean isDestReplaceable = destBlockState.func_177230_c().func_176200_f((IBlockAccess)world, pos);
        if (!(world.func_175623_d(pos) || isDestNonSolid && ignoreReplacable && isDestReplaceable)) {
            return null;
        }
        ItemStorageBlockWrapper destinationBlock = new ItemStorageBlockWrapper(true, (WorldServer)world, pos, side, hand, blockUpdate, 0, false, ignoreReplacable, true);
        return TunnelHelpers.moveSingleStateOptimized(network, ingredientsNetwork, channel, connection, source, -1, destinationBlock, -1, itemStackMatcher, PartPos.of((World)world, (BlockPos)pos, (EnumFacing)side), craftIfFailed);
    }

    public static List<ItemStack> pickUpItems(INetwork network, IPositionedAddonsNetworkIngredients<ItemStack, Integer> ingredientsNetwork, int channel, ITunnelConnection connection, World world, BlockPos pos, EnumFacing side, IIngredientComponentStorage<ItemStack, Integer> destination, IngredientPredicate<ItemStack, Integer> itemStackMatcher, EnumHand hand, boolean blockUpdate, boolean ignoreReplacable, int fortune, boolean silkTouch, boolean breakOnNoDrops) throws EvaluationException {
        ItemStack itemStack;
        IBlockState destBlockState = world.func_180495_p(pos);
        Material destMaterial = destBlockState.func_185904_a();
        boolean isDestReplaceable = destBlockState.func_177230_c().func_176200_f((IBlockAccess)world, pos);
        if (world.func_175623_d(pos) || ignoreReplacable && isDestReplaceable || destMaterial.func_76224_d()) {
            return null;
        }
        ItemStorageBlockWrapper sourceBlock = new ItemStorageBlockWrapper(false, (WorldServer)world, pos, side, hand, blockUpdate, fortune, silkTouch, ignoreReplacable, breakOnNoDrops);
        ArrayList itemStacks = Lists.newArrayList();
        while (!(itemStack = TunnelHelpers.moveSingleStateOptimized(network, ingredientsNetwork, channel, connection, sourceBlock, -1, destination, -1, itemStackMatcher, PartPos.of((World)world, (BlockPos)pos, (EnumFacing)side), false)).func_190926_b()) {
            itemStacks.add(itemStack);
        }
        List<ItemStack> cachedDrops = sourceBlock.getCachedDrops();
        if (sourceBlock.isExtracted() && cachedDrops != null) {
            Iterator<ItemStack> it = cachedDrops.iterator();
            while (it.hasNext()) {
                ItemStack cachedStack = it.next();
                if (cachedStack.func_190926_b()) continue;
                ItemStack remaining = (ItemStack)destination.insert((Object)cachedStack, false);
                if (GeneralConfig.ejectItemsOnBlockDropOverflow) {
                    ItemStackHelpers.spawnItemStack((World)world, (BlockPos)pos, (ItemStack)remaining);
                }
                it.remove();
            }
            sourceBlock.postExtract();
        }
        return itemStacks;
    }

    public static ItemStack prototypeWithCount(ItemStack prototype, int count) {
        if (prototype.func_190916_E() != count) {
            if (prototype.func_190926_b()) {
                return new ItemStack(Items.field_151034_e, count);
            }
            prototype = prototype.func_77946_l();
            prototype.func_190920_e(count);
        }
        return prototype;
    }
}

