/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.stevekunglib.world.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import stevekung.mods.stevekunglib.utils.BlockStateProperty;
import stevekung.mods.stevekunglib.world.gen.WorldGenAbstractTree;

public abstract class WorldGenAbstractBigTree
extends WorldGenAbstractTree {
    private Random rand;
    private World world;
    private BlockPos pos = BlockPos.field_177992_a;
    private final IBlockState leaves;
    private final IBlockState log;
    protected boolean genLeaves = true;
    int heightLimit;
    int height;
    double heightAttenuation = 0.618;
    double branchSlope = 0.381;
    double scaleWidth = 1.0;
    double leafDensity = 1.0;
    int trunkSize = 1;
    int heightLimitLimit = 12;
    int leafDistanceLimit = 4;
    List<FoliageCoordinates> foliageCoords;

    public WorldGenAbstractBigTree(IBlockState log, IBlockState leaves) {
        super(log, leaves);
        this.log = log;
        this.leaves = leaves;
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        this.world = world;
        this.pos = pos;
        this.rand = new Random(rand.nextLong());
        if (this.heightLimit == 0) {
            this.heightLimit = 5 + this.rand.nextInt(this.heightLimitLimit);
        }
        if (!this.validTreeLocation()) {
            this.world = null;
            return false;
        }
        this.generateLeafNodeList();
        if (this.genLeaves) {
            this.generateLeaves();
        }
        this.generateTrunk();
        this.generateLeafNodeBases();
        this.world = null;
        return true;
    }

    void generateLeafNodeList() {
        int k;
        int i;
        this.height = (int)((double)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if ((i = (int)(1.382 + Math.pow(this.leafDensity * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            i = 1;
        }
        int j = this.pos.func_177956_o() + this.height;
        this.foliageCoords = new ArrayList<FoliageCoordinates>();
        this.foliageCoords.add(new FoliageCoordinates(this.pos.func_177981_b(k), j));
        for (k = this.heightLimit - this.leafDistanceLimit; k >= 0; --k) {
            float f = this.layerSize(k);
            if (!(f >= 0.0f)) continue;
            for (int l = 0; l < i; ++l) {
                BlockPos blockpos1;
                double d3;
                double d1;
                double d0 = this.scaleWidth * (double)f * ((double)this.rand.nextFloat() + 0.328);
                double d2 = d0 * Math.sin(d1 = (double)(this.rand.nextFloat() * 2.0f) * Math.PI) + 0.5;
                BlockPos blockpos = this.pos.func_177963_a(d2, (double)(k - 1), d3 = d0 * Math.cos(d1) + 0.5);
                if (this.checkBlockLine(blockpos, blockpos1 = blockpos.func_177981_b(this.leafDistanceLimit)) != -1) continue;
                int i1 = this.pos.func_177958_n() - blockpos.func_177958_n();
                int j1 = this.pos.func_177952_p() - blockpos.func_177952_p();
                double d4 = (double)blockpos.func_177956_o() - Math.sqrt(i1 * i1 + j1 * j1) * this.branchSlope;
                int k1 = d4 > (double)j ? j : (int)d4;
                BlockPos blockpos2 = new BlockPos(this.pos.func_177958_n(), k1, this.pos.func_177952_p());
                if (this.checkBlockLine(blockpos2, blockpos) != -1) continue;
                this.foliageCoords.add(new FoliageCoordinates(blockpos, blockpos2.func_177956_o()));
            }
        }
    }

    void crosSection(BlockPos pos, float leafSize, IBlockState placeState) {
        int i = (int)((double)leafSize + 0.618);
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                BlockPos blockpos;
                IBlockState state;
                if (!(Math.pow((double)Math.abs(j) + 0.5, 2.0) + Math.pow((double)Math.abs(k) + 0.5, 2.0) <= (double)(leafSize * leafSize)) || !(state = this.world.func_180495_p(blockpos = pos.func_177982_a(j, 0, k))).func_177230_c().isAir(state, (IBlockAccess)this.world, blockpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)this.world, blockpos)) continue;
                this.func_175903_a(this.world, blockpos, placeState);
            }
        }
    }

    float layerSize(int y) {
        if ((float)y < (float)this.heightLimit * 0.3f) {
            return -1.0f;
        }
        float f = (float)this.heightLimit / 2.0f;
        float f1 = f - (float)y;
        float f2 = MathHelper.func_76129_c((float)(f * f - f1 * f1));
        if (f1 == 0.0f) {
            f2 = f;
        } else if (Math.abs(f1) >= f) {
            return 0.0f;
        }
        return f2 * 0.5f;
    }

    float leafSize(int y) {
        if (y >= 0 && y < this.leafDistanceLimit) {
            return y != 0 && y != this.leafDistanceLimit - 1 ? 3.0f : 2.0f;
        }
        return -1.0f;
    }

    void generateLeafNode(BlockPos pos) {
        for (int i = 0; i < this.leafDistanceLimit; ++i) {
            this.crosSection(pos.func_177981_b(i), this.leafSize(i), this.leaves.func_177226_a((IProperty)BlockStateProperty.CHECK_DECAY, (Comparable)Boolean.valueOf(false)));
        }
    }

    void limb(BlockPos pos1, BlockPos pos2, IBlockState log) {
        BlockPos blockpos = pos2.func_177982_a(-pos1.func_177958_n(), -pos1.func_177956_o(), -pos1.func_177952_p());
        int i = this.getGreatestDistance(blockpos);
        float f = (float)blockpos.func_177958_n() / (float)i;
        float f1 = (float)blockpos.func_177956_o() / (float)i;
        float f2 = (float)blockpos.func_177952_p() / (float)i;
        for (int j = 0; j <= i; ++j) {
            BlockPos blockpos1 = pos1.func_177963_a((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2));
            BlockStateProperty.EnumAxis axis = this.getLogAxis(pos1, blockpos1);
            this.func_175903_a(this.world, blockpos1, log.func_177226_a(BlockStateProperty.AXIS, (Comparable)((Object)axis)));
        }
    }

    private int getGreatestDistance(BlockPos pos) {
        int i = MathHelper.func_76130_a((int)pos.func_177958_n());
        int j = MathHelper.func_76130_a((int)pos.func_177956_o());
        int k = MathHelper.func_76130_a((int)pos.func_177952_p());
        if (k > i && k > j) {
            return k;
        }
        return Math.max(j, i);
    }

    private BlockStateProperty.EnumAxis getLogAxis(BlockPos pos1, BlockPos pos2) {
        int j;
        BlockStateProperty.EnumAxis axis = BlockStateProperty.EnumAxis.Y;
        int i = Math.abs(pos2.func_177958_n() - pos1.func_177958_n());
        int k = Math.max(i, j = Math.abs(pos2.func_177952_p() - pos1.func_177952_p()));
        if (k > 0) {
            if (i == k) {
                axis = BlockStateProperty.EnumAxis.X;
            } else if (j == k) {
                axis = BlockStateProperty.EnumAxis.Z;
            }
        }
        return axis;
    }

    void generateLeaves() {
        for (FoliageCoordinates coord : this.foliageCoords) {
            this.generateLeafNode(coord);
        }
    }

    boolean leafNodeNeedsBase(int base) {
        return (double)base >= (double)this.heightLimit * 0.2;
    }

    void generateTrunk() {
        BlockPos blockpos = this.pos;
        BlockPos blockpos1 = this.pos.func_177981_b(this.height);
        this.limb(blockpos, blockpos1, this.log);
        if (this.trunkSize == 2) {
            this.limb(blockpos.func_177974_f(), blockpos1.func_177974_f(), this.log);
            this.limb(blockpos.func_177974_f().func_177968_d(), blockpos1.func_177974_f().func_177968_d(), this.log);
            this.limb(blockpos.func_177968_d(), blockpos1.func_177968_d(), this.log);
        }
    }

    void generateLeafNodeBases() {
        for (FoliageCoordinates coord : this.foliageCoords) {
            int i = coord.getBranchBase();
            BlockPos pos = new BlockPos(this.pos.func_177958_n(), i, this.pos.func_177952_p());
            if (pos.equals((Object)coord) || !this.leafNodeNeedsBase(i - this.pos.func_177956_o())) continue;
            this.limb(pos, coord, this.log);
        }
    }

    int checkBlockLine(BlockPos posOne, BlockPos posTwo) {
        BlockPos blockpos = posTwo.func_177982_a(-posOne.func_177958_n(), -posOne.func_177956_o(), -posOne.func_177952_p());
        int i = this.getGreatestDistance(blockpos);
        float f = (float)blockpos.func_177958_n() / (float)i;
        float f1 = (float)blockpos.func_177956_o() / (float)i;
        float f2 = (float)blockpos.func_177952_p() / (float)i;
        if (i != 0) {
            for (int j = 0; j <= i; ++j) {
                BlockPos blockpos1 = posOne.func_177963_a((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2));
                if (this.isReplaceable(this.world, blockpos1)) continue;
                return j;
            }
        }
        return -1;
    }

    public void func_175904_e() {
        this.leafDistanceLimit = 5;
    }

    private boolean validTreeLocation() {
        BlockPos down = this.pos.func_177977_b();
        IBlockState state = this.world.func_180495_p(down);
        boolean isSoil = this.isSoil(state.func_177230_c());
        if (!isSoil) {
            return false;
        }
        int i = this.checkBlockLine(this.pos, this.pos.func_177981_b(this.heightLimit - 1));
        if (i == -1) {
            return true;
        }
        if (i < 6) {
            return false;
        }
        this.heightLimit = i;
        return true;
    }

    @Override
    protected abstract boolean isSoil(Block var1);

    static class FoliageCoordinates
    extends BlockPos {
        private final int branchBase;

        public FoliageCoordinates(BlockPos pos, int branchBase) {
            super(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.branchBase = branchBase;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }
}

