/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.stevekunglib.world.gen;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import stevekung.mods.stevekunglib.world.gen.WorldGenAbstractTree;

public abstract class WorldGenAbstractHugeTrees
extends WorldGenAbstractTree {
    protected final int baseHeight;
    private final IBlockState leaves;
    private final int extraRandomHeight;

    public WorldGenAbstractHugeTrees(int baseHeight, int extraRandomHeight, IBlockState leaves) {
        super(null, null);
        this.baseHeight = baseHeight;
        this.extraRandomHeight = extraRandomHeight;
        this.leaves = leaves;
    }

    protected int getHeight(Random rand) {
        int i = rand.nextInt(3) + this.baseHeight;
        if (this.extraRandomHeight > 1) {
            i += rand.nextInt(this.extraRandomHeight);
        }
        return i;
    }

    private boolean isSpaceAt(World world, BlockPos leavesPos, int height) {
        boolean flag = true;
        if (leavesPos.func_177956_o() >= 1 && leavesPos.func_177956_o() + height + 1 <= 256) {
            for (int i = 0; i <= 1 + height; ++i) {
                int j = 2;
                if (i == 0) {
                    j = 1;
                } else if (i >= 1 + height - 2) {
                    j = 2;
                }
                for (int k = -j; k <= j && flag; ++k) {
                    for (int l = -j; l <= j && flag; ++l) {
                        if (leavesPos.func_177956_o() + i >= 0 && leavesPos.func_177956_o() + i < 256 && this.isReplaceable(world, leavesPos.func_177982_a(k, i, l))) continue;
                        flag = false;
                    }
                }
            }
            return flag;
        }
        return false;
    }

    private boolean ensureDirtsUnderneath(BlockPos pos, World world) {
        BlockPos blockpos = pos.func_177977_b();
        IBlockState state = world.func_180495_p(blockpos);
        boolean isSoil = this.isSoil(state.func_177230_c());
        if (isSoil && pos.func_177956_o() >= 2) {
            this.onPlantGrow(world, blockpos, pos);
            this.onPlantGrow(world, blockpos.func_177974_f(), pos);
            this.onPlantGrow(world, blockpos.func_177968_d(), pos);
            this.onPlantGrow(world, blockpos.func_177968_d().func_177974_f(), pos);
            return true;
        }
        return false;
    }

    protected boolean ensureGrowable(World world, BlockPos treePos, int height) {
        return this.isSpaceAt(world, treePos, height) && this.ensureDirtsUnderneath(treePos, world);
    }

    protected void growLeavesLayerStrict(World world, BlockPos layerCenter, int width) {
        int i = width * width;
        for (int j = -width; j <= width + 1; ++j) {
            for (int k = -width; k <= width + 1; ++k) {
                BlockPos blockpos;
                IBlockState state;
                int l = j - 1;
                int i1 = k - 1;
                if (j * j + k * k > i && l * l + i1 * i1 > i && j * j + i1 * i1 > i && l * l + k * k > i || !(state = world.func_180495_p(blockpos = layerCenter.func_177982_a(j, 0, k))).func_177230_c().isAir(state, (IBlockAccess)world, blockpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, blockpos)) continue;
                this.func_175903_a(world, blockpos, this.leaves);
            }
        }
    }

    protected void growLeavesLayer(World world, BlockPos layerCenter, int width) {
        int i = width * width;
        for (int j = -width; j <= width; ++j) {
            for (int k = -width; k <= width; ++k) {
                BlockPos blockpos;
                IBlockState state;
                if (j * j + k * k > i || !(state = world.func_180495_p(blockpos = layerCenter.func_177982_a(j, 0, k))).func_177230_c().isAir(state, (IBlockAccess)world, blockpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, blockpos)) continue;
                this.func_175903_a(world, blockpos, this.leaves);
            }
        }
    }

    private void onPlantGrow(World world, BlockPos pos, BlockPos source) {
        IBlockState state = world.func_180495_p(pos);
        state.func_177230_c().onPlantGrow(state, world, pos, source);
    }
}

