/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.wrappers;

import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidHandlerWrapper
implements IFluidHandler {
    public IFluidHandlerWrapper wrapper;
    public EnumFacing side;

    public FluidHandlerWrapper(IFluidHandlerWrapper w, EnumFacing s) {
        this.wrapper = w;
        this.side = s;
    }

    public IFluidTankProperties[] getTankProperties() {
        FluidTankInfo[] infos = this.wrapper.getTankInfo(this.side);
        if (infos != null) {
            FluidTankProperties[] properties = new FluidTankProperties[infos.length];
            for (int i = 0; i < infos.length; ++i) {
                FluidTankInfo info = infos[i];
                properties[i] = new FluidTankProperties(info.fluid, info.capacity, this.wrapper.canFill(this.side, null), this.wrapper.canDrain(this.side, null));
            }
            return properties;
        }
        return new IFluidTankProperties[0];
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.wrapper.canFill(this.side, resource != null ? resource.getFluid() : null)) {
            return this.wrapper.fill(this.side, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.wrapper.canDrain(this.side, resource != null ? resource.getFluid() : null)) {
            return this.wrapper.drain(this.side, resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.wrapper.canDrain(this.side, null)) {
            return this.wrapper.drain(this.side, maxDrain, doDrain);
        }
        return null;
    }
}

