/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.client.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementCheckbox;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementGradientList;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementTextBox;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.venus.network.PacketSimpleVenus;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntityLaserTurret;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.lwjgl.opengl.GL11;

public class GuiLaserTurretEditList
extends GuiScreen
implements GuiElementTextBox.ITextBoxCallback,
GuiElementCheckbox.ICheckBoxCallback {
    private static final ResourceLocation backgroundTexture = new ResourceLocation("galacticraftplanets", "textures/gui/laser_turret_edit.png");
    private final TileEntityLaserTurret laserTurret;
    private GuiElementGradientList entityListElement;
    private int ySize;
    private int xSize;
    private EnumMode mode = EnumMode.MAIN;
    private GuiElementTextBox name;
    private GuiElementCheckbox neverAttackSpaceRace;

    public GuiLaserTurretEditList(TileEntityLaserTurret turret) {
        this.laserTurret = turret;
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.mode = EnumMode.ADD_PLAYER;
                this.func_73866_w_();
                break;
            }
            case 1: {
                this.mode = EnumMode.ADD_ENTITY;
                this.func_73866_w_();
                break;
            }
            case 2: {
                GuiElementGradientList.ListElement selected = this.entityListElement.getSelectedElement();
                if (selected == null) break;
                boolean isPlayer = selected.value.contains(GCCoreUtil.translate("gui.message.player.name") + ": ");
                String toSend = isPlayer ? selected.value.substring(8) : selected.value;
                GalacticraftCore.packetPipeline.sendToServer(new PacketSimpleVenus(PacketSimpleVenus.EnumSimplePacketVenus.S_MODIFY_LASER_TARGET, GCCoreUtil.getDimensionID(this.laserTurret.func_145831_w()), new Object[]{isPlayer ? 2 : 3, this.laserTurret.func_174877_v(), toSend}));
                if (isPlayer) {
                    this.laserTurret.removePlayer(toSend);
                } else {
                    this.laserTurret.removeEntity(new ResourceLocation(toSend));
                }
                this.func_73866_w_();
                break;
            }
            case 4: {
                if (this.mode == EnumMode.ADD_ENTITY) {
                    EntityEntry entry = this.getEntityEntry();
                    if (entry != null) {
                        GalacticraftCore.packetPipeline.sendToServer(new PacketSimpleVenus(PacketSimpleVenus.EnumSimplePacketVenus.S_MODIFY_LASER_TARGET, GCCoreUtil.getDimensionID(this.laserTurret.func_145831_w()), new Object[]{1, this.laserTurret.func_174877_v(), entry.getRegistryName().toString()}));
                        this.laserTurret.addEntity(entry.getRegistryName());
                    }
                } else if (this.mode == EnumMode.ADD_PLAYER && this.name.text != null && !this.name.text.isEmpty()) {
                    GalacticraftCore.packetPipeline.sendToServer(new PacketSimpleVenus(PacketSimpleVenus.EnumSimplePacketVenus.S_MODIFY_LASER_TARGET, GCCoreUtil.getDimensionID(this.laserTurret.func_145831_w()), new Object[]{0, this.laserTurret.func_174877_v(), this.name.text}));
                    this.laserTurret.addPlayer(this.name.text);
                }
                this.name.text = null;
                this.mode = EnumMode.MAIN;
                this.func_73866_w_();
            }
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        super.func_73866_w_();
        switch (this.mode) {
            case MAIN: {
                this.ySize = 144;
                this.xSize = 222;
                int yTop = (this.field_146295_m - this.ySize) / 2;
                this.field_146292_n.add(new GuiButton(0, (this.field_146294_l - this.xSize) / 2 + 4, yTop + 5, 62, 20, GCCoreUtil.translate("gui.button.add_player.name")));
                this.field_146292_n.add(new GuiButton(1, (this.field_146294_l - this.xSize) / 2 + 66, yTop + 5, 62, 20, GCCoreUtil.translate("gui.button.add_entity.name")));
                this.field_146292_n.add(new GuiButton(2, (this.field_146294_l - this.xSize) / 2 + 128, yTop + 5, 90, 20, GCCoreUtil.translate("gui.button.remove_selected.name")));
                this.entityListElement = new GuiElementGradientList((this.field_146294_l - this.xSize) / 2 + 4, yTop + 26, this.xSize - 8, this.ySize - 45);
                ArrayList alphabeticalList = Lists.newArrayList();
                alphabeticalList.addAll(this.laserTurret.getPlayers());
                for (ResourceLocation res : this.laserTurret.getEntities()) {
                    alphabeticalList.add(res.toString());
                }
                Collections.sort(alphabeticalList);
                for (int i = 0; i < alphabeticalList.size(); ++i) {
                    if (!this.laserTurret.getPlayers().contains(alphabeticalList.get(i))) continue;
                    alphabeticalList.set(i, GCCoreUtil.translate("gui.message.player.name") + ": " + (String)alphabeticalList.get(i));
                }
                ArrayList list = Lists.newArrayList();
                for (String str : alphabeticalList) {
                    list.add(new GuiElementGradientList.ListElement(str, ColorUtil.to32BitColor(255, 240, 240, 240)));
                }
                this.entityListElement.updateListContents(list);
                this.neverAttackSpaceRace = new GuiElementCheckbox(5, this, this.field_146294_l / 2 - 106, yTop + 126, GCCoreUtil.translate("gui.button.never_fire_team.name"), 0x404040);
                this.field_146292_n.add(this.neverAttackSpaceRace);
                break;
            }
            case ADD_PLAYER: 
            case ADD_ENTITY: {
                this.ySize = 70;
                this.xSize = 148;
                int yTop = (this.field_146295_m - this.ySize) / 2;
                this.name = new GuiElementTextBox(3, this, (this.field_146294_l - this.xSize) / 2 + 4, yTop + 16, 140, 20, "", false, 64, false);
                this.name.resetOnClick = false;
                this.func_189646_b(this.name);
                this.field_146292_n.add(new GuiButton(4, (this.field_146294_l - this.xSize) / 2 + this.xSize / 2 - 31, yTop + 40, 62, 20, GCCoreUtil.translate(this.laserTurret.blacklistMode ? "gui.button.add_blacklist.name" : "gui.button.add_whitelist.name")));
            }
        }
    }

    protected void func_73869_a(char keyChar, int keyID) throws IOException {
        if (this.mode != EnumMode.MAIN && keyID != 1 && this.name.keyTyped(keyChar, keyID)) {
            return;
        }
        if (keyID == 1) {
            switch (this.mode) {
                case MAIN: {
                    GalacticraftCore.packetPipeline.sendToServer(new PacketSimpleVenus(PacketSimpleVenus.EnumSimplePacketVenus.S_OPEN_LASER_TURRET_GUI, GCCoreUtil.getDimensionID(this.laserTurret.func_145831_w()), new Object[]{this.laserTurret.func_174877_v()}));
                    break;
                }
                default: {
                    this.mode = EnumMode.MAIN;
                    this.func_73866_w_();
                    break;
                }
            }
        } else {
            super.func_73869_a(keyChar, keyID);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73876_c() {
        if (this.mode == EnumMode.MAIN) {
            this.entityListElement.update();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(backgroundTexture);
        int var5 = (this.field_146294_l - this.xSize) / 2;
        int var6 = (this.field_146295_m - this.ySize) / 2;
        this.func_73729_b(var5, var6, 0, this.mode == EnumMode.MAIN ? 0 : 144, this.xSize, this.ySize);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.mode == EnumMode.MAIN) {
            this.entityListElement.draw(mouseX, mouseY);
        } else if (this.mode == EnumMode.ADD_PLAYER) {
            String displayString = GCCoreUtil.translate("gui.message.enter_player.name");
            this.field_146289_q.func_78276_b(displayString, var5 + this.xSize / 2 - this.field_146289_q.func_78256_a(displayString) / 2, var6 + 5, 0x404040);
        } else if (this.mode == EnumMode.ADD_ENTITY) {
            String displayString = GCCoreUtil.translate("gui.message.enter_entity.name");
            this.field_146289_q.func_78276_b(displayString, var5 + this.xSize / 2 - this.field_146289_q.func_78256_a(displayString) / 2, var6 + 5, 0x404040);
        }
    }

    private EntityEntry getEntityEntry() {
        if (this.name.text != null) {
            EntityEntry entry;
            for (ResourceLocation loc : ForgeRegistries.ENTITIES.getKeys()) {
                if (!this.name.text.equalsIgnoreCase(loc.toString())) continue;
                return (EntityEntry)ForgeRegistries.ENTITIES.getValue(loc);
            }
            for (ResourceLocation loc : ForgeRegistries.ENTITIES.getKeys()) {
                if (!this.name.text.equalsIgnoreCase(loc.func_110623_a())) continue;
                return (EntityEntry)ForgeRegistries.ENTITIES.getValue(loc);
            }
            for (ResourceLocation loc : ForgeRegistries.ENTITIES.getKeys()) {
                entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(loc);
                if (entry == null || !this.name.text.equalsIgnoreCase(entry.getName())) continue;
                return entry;
            }
            for (ResourceLocation loc : ForgeRegistries.ENTITIES.getKeys()) {
                entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(loc);
                if (entry == null || !this.name.text.equalsIgnoreCase(I18n.func_74838_a((String)("entity." + entry.getName() + ".name")))) continue;
                return entry;
            }
        }
        return null;
    }

    @Override
    public boolean canPlayerEdit(GuiElementTextBox textBox, EntityPlayer player) {
        return player.func_110124_au().equals(this.laserTurret.getOwnerUUID());
    }

    @Override
    public void onTextChanged(GuiElementTextBox textBox, String newText) {
    }

    @Override
    public String getInitialText(GuiElementTextBox textBox) {
        return "";
    }

    @Override
    public int getTextColor(GuiElementTextBox textBox) {
        if (this.mode == EnumMode.ADD_ENTITY) {
            if (this.getEntityEntry() != null) {
                return ColorUtil.to32BitColor(255, 80, 200, 80);
            }
            return ColorUtil.to32BitColor(255, 200, 80, 80);
        }
        return ColorUtil.to32BitColor(255, 200, 200, 200);
    }

    @Override
    public void onIntruderInteraction(GuiElementTextBox textBox) {
    }

    @Override
    public void onSelectionChanged(GuiElementCheckbox checkbox, boolean newSelected) {
        this.laserTurret.alwaysIgnoreSpaceRace = newSelected;
        GalacticraftCore.packetPipeline.sendToServer(new PacketSimpleVenus(PacketSimpleVenus.EnumSimplePacketVenus.S_UPDATE_ADVANCED_GUI, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{2, this.laserTurret.func_174877_v(), this.laserTurret.alwaysIgnoreSpaceRace ? 1 : 0}));
    }

    @Override
    public boolean canPlayerEdit(GuiElementCheckbox checkbox, EntityPlayer player) {
        return player.func_110124_au().equals(this.laserTurret.getOwnerUUID());
    }

    @Override
    public boolean getInitiallySelected(GuiElementCheckbox checkbox) {
        return this.laserTurret.alwaysIgnoreSpaceRace;
    }

    @Override
    public void onIntruderInteraction() {
    }

    private static enum EnumMode {
        MAIN,
        ADD_PLAYER,
        ADD_ENTITY;

    }
}

