/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.capability.recipehandler;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;

public abstract class TransformedRecipeHandlerAdapter<R>
implements IRecipeHandler {
    private static final Map<String, Collection<IRecipeDefinition>> CACHED_RECIPES = Maps.newHashMap();
    private final Set<IngredientComponent<?, ?>> inputComponents;
    private final Set<IngredientComponent<?, ?>> outputComponents;
    private Collection<IRecipeDefinition> recipes;

    public TransformedRecipeHandlerAdapter(Set<IngredientComponent<?, ?>> inputComponents, Set<IngredientComponent<?, ?>> outputComponents) {
        this.inputComponents = inputComponents;
        this.outputComponents = outputComponents;
    }

    protected boolean isRecipeCacheEnabled() {
        return true;
    }

    protected abstract String getRecipeCacheKey();

    protected abstract IRecipeDefinition transformRecipe(R var1);

    protected abstract R findRecipe(IMixedIngredients var1);

    protected abstract Collection<R> getRecipesRaw();

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeInputComponents() {
        return this.inputComponents;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeOutputComponents() {
        return this.outputComponents;
    }

    @Override
    public Collection<IRecipeDefinition> getRecipes() {
        if (this.recipes == null) {
            if (this.isRecipeCacheEnabled() && CACHED_RECIPES.containsKey(this.getRecipeCacheKey())) {
                this.recipes = CACHED_RECIPES.get(this.getRecipeCacheKey());
            } else {
                this.recipes = this.getRecipesRaw().stream().map(this::transformRecipe).collect(Collectors.toList());
                CACHED_RECIPES.put(this.getRecipeCacheKey(), this.recipes);
            }
        }
        return this.recipes;
    }

    @Override
    @Nullable
    public IMixedIngredients simulate(IMixedIngredients input) {
        R teRecipe = this.findRecipe(input);
        return teRecipe == null ? null : this.transformRecipe(teRecipe).getOutput();
    }
}

