/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.grave;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.inventory.EnderInventory;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.BlockEio;
import crazypants.enderio.base.ItemEIO;
import crazypants.enderio.base.block.grave.TESRGrave;
import crazypants.enderio.base.block.grave.TileGrave;
import crazypants.enderio.base.config.config.ItemConfig;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.render.IHaveTESR;
import crazypants.enderio.base.render.registry.SmartModelAttacher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGrave
extends BlockEio<TileGrave>
implements IResourceTooltipProvider,
IHaveTESR {
    @Nonnull
    protected static final AxisAlignedBB DEFAULT_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);

    public static BlockGrave create(@Nonnull IModObject modObject) {
        BlockGrave res = new BlockGrave(modObject);
        res.init();
        return res;
    }

    public BlockGrave(@Nonnull IModObject modObject) {
        super(modObject);
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
        this.func_149713_g(0);
        this.mkShape(BlockFaceShape.UNDEFINED);
    }

    @Override
    protected void init() {
        super.init();
        SmartModelAttacher.registerItemOnly((Block)this);
    }

    @Override
    @Nullable
    public ItemEIO createBlockItem(@Nonnull IModObject modObject) {
        return (ItemEIO)modObject.apply(new ItemEIO(this){

            @Nonnull
            public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
                return EnumActionResult.FAIL;
            }

            @Nonnull
            public String func_77658_a() {
                return BlockGrave.this.func_149739_a().replace("tile", "item");
            }

            @Nonnull
            public String func_77667_c(@Nonnull ItemStack stack) {
                return this.func_77658_a();
            }
        }).func_77625_d(16);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void bindTileEntitySpecialRenderer() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileGrave.class, (TileEntitySpecialRenderer)new TESRGrave((Block)this));
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        return DEFAULT_AABB;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Override
    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        if (!world.field_72995_K) {
            TileGrave te = (TileGrave)this.getTileEntity((IBlockAccess)world, pos);
            if (te != null && (te.getOwner().equals(player.func_146103_bH()) || player.func_184812_l_() || !((Boolean)ItemConfig.dpPrivate.get()).booleanValue())) {
                EnderInventory inventory = te.getInventory();
                for (int slot = 0; slot < inventory.getSlots(); ++slot) {
                    ItemStack stack = inventory.getStackInSlot(slot).func_77946_l();
                    if (player.field_71071_by.func_70441_a(stack)) continue;
                    BlockGrave.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
                }
                world.func_175698_g(pos);
            } else {
                player.func_146105_b((ITextComponent)Lang.GUI_GRAVE_NOT_OWNER.toChatServer(), true);
            }
        }
        return true;
    }

    public boolean canHarvestBlock(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return false;
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        return false;
    }

    @Override
    protected boolean canBeWrenched() {
        return false;
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack itemStack) {
        return itemStack.func_77977_a();
    }
}

