/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.command;

import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.registry.Registry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="enderio", value={Side.SERVER})
public class CommandConfig
extends CommandBase {
    @Nonnull
    private final Map<String, Configuration> configurations;
    @Nonnull
    private final TreeMap<String, ConfigCategory> sections = new TreeMap();

    @SubscribeEvent
    public static void onStarting(EnderIOLifecycleEvent.ServerStarting.Dedicated event) {
        event.getEvent().registerServerCommand((ICommand)new CommandConfig());
    }

    private CommandConfig() {
        this.configurations = Registry.getConfigurations();
        for (Map.Entry<String, Configuration> entry : this.configurations.entrySet()) {
            for (String name : entry.getValue().getCategoryNames()) {
                this.sections.put(entry.getKey() + "." + name, entry.getValue().getCategory(name));
            }
        }
    }

    @Nonnull
    public String func_71517_b() {
        return "enderio";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "/" + this.func_71517_b() + " config set <section> <key> <value>|config get <section> <key>|config list [<section>]|config save|config help";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (this.match(args, "config", "set", null, null, null)) {
            this.doSet(server, sender, args[2], args[3], args[4]);
        } else if (this.match(args, "config", "get", null, null)) {
            this.doGet(server, sender, args[2], args[3]);
        } else if (this.match(args, "config", "list", null)) {
            this.doList(server, sender, args[2]);
        } else if (this.match(args, "config", "list")) {
            this.doList(server, sender);
        } else if (this.match(args, "config", "save")) {
            this.doSave(server, sender);
        } else if (this.match(args, "config", "help", null)) {
            this.doHelp(server, sender, args[2]);
        } else if (this.match(args, "config", "help")) {
            this.doHelp(server, sender, "0");
        } else {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
    }

    private void doHelp(MinecraftServer server, ICommandSender sender, String page) {
        Integer no = this.getPageNumber(page);
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("enderio.command.config.help." + no, new Object[0]));
        if (no < 5) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("enderio.command.config.help.more", new Object[]{no + 1}));
        }
    }

    protected Integer getPageNumber(String page) {
        try {
            return MathHelper.func_76125_a((int)Integer.valueOf(page), (int)0, (int)4);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void doSave(MinecraftServer server, ICommandSender sender) {
        MinecraftForge.EVENT_BUS.post((Event)new ConfigChangedEvent.OnConfigChangedEvent("enderio", null, true, false));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("enderio.command.config.saved", new Object[0]));
    }

    private void doList(MinecraftServer server, ICommandSender sender, String section) {
        if (this.sections.containsKey(section) && !this.sections.get(section).isEmpty()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(this.sections.get(section).getOrderedValues().stream().map(property -> property.getName()).collect(Collectors.joining(", "))));
        } else {
            String list = this.sections.keySet().stream().filter(name -> name.startsWith(section)).collect(Collectors.joining(", "));
            if (list != null && !list.isEmpty()) {
                sender.func_145747_a((ITextComponent)new TextComponentString(list));
            } else {
                list = this.sections.keySet().stream().filter(name -> name.contains(section)).collect(Collectors.joining(", "));
                if (list != null && !list.isEmpty()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(list));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("enderio.command.config.error.section", new Object[0]));
                }
            }
        }
    }

    private void doList(MinecraftServer server, ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(this.sections.keySet().stream().collect(Collectors.joining(", "))));
    }

    private void doGet(MinecraftServer server, ICommandSender sender, String section, String key) {
        if (this.sections.containsKey(section) && !this.sections.get(section).isEmpty()) {
            Property property = this.sections.get(section).get(key);
            if (property != null) {
                this.sendKeyComments(sender, property, section, key, false, false);
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("enderio.command.config.error.key", new Object[0]));
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("enderio.command.config.error.section", new Object[0]));
        }
    }

    private void sendKeyComments(ICommandSender sender, Property property, String section, String key, boolean isSet, boolean isValidSet) {
        String comment = property.getComment();
        if (comment != null && !comment.isEmpty()) {
            if (!isSet) {
                sender.func_145747_a((ITextComponent)new TextComponentString(comment));
            }
        } else {
            comment = "";
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(section + " " + key + " = " + property.getString()));
        if (!comment.contains(" (synced from server)")) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("enderio.command.config.warn.clientvalue", new Object[0]));
        } else if (isSet) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("enderio.command.config.warn.reconnect", new Object[0]));
        }
        if (comment.contains(" (must be kept in sync with server)")) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("enderio.command.config.warn.notsynced", new Object[0]));
        }
        if (isSet) {
            if (!isValidSet) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("enderio.command.config.warn.unchecked", new Object[0]));
            }
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("enderio.command.config.warn.save", new Object[0]));
        }
    }

    private void doSet(MinecraftServer server, ICommandSender sender, String section, String key, String value) {
        if (this.sections.containsKey(section) && !this.sections.get(section).isEmpty()) {
            Property property = this.sections.get(section).get(key);
            if (property != null) {
                Object[] validValues = property.getValidValues();
                if (validValues != null && validValues.length > 0) {
                    for (String string : validValues) {
                        if (!value.equals(string)) continue;
                        property.set(value);
                        this.sendKeyComments(sender, property, section, key, true, true);
                        return;
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("enderio.command.config.error.key", new Object[]{CommandConfig.func_71527_a((Object[])validValues)}));
                } else {
                    property.set(value);
                    this.sendKeyComments(sender, property, section, key, true, false);
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("enderio.command.config.error.key", new Object[0]));
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("enderio.command.config.error.section", new Object[0]));
        }
    }

    private boolean match(@Nonnull String[] args, String ... pattern) {
        if (args.length != pattern.length) {
            return false;
        }
        for (int i = 0; i < pattern.length; ++i) {
            if (pattern[i] == null || pattern[i].equals(args[i])) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args, @Nullable BlockPos targetPos) {
        if (args.length <= 1) {
            return CommandConfig.func_71530_a((String[])args, (String[])new String[]{"config"});
        }
        if ("config".equals(args[0])) {
            if (args.length == 2) {
                return CommandConfig.func_71530_a((String[])args, (String[])new String[]{"set", "get", "list", "save", "help"});
            }
            if ("set".equals(args[1]) || "get".equals(args[1]) || "list".equals(args[1])) {
                if (args.length == 3) {
                    return CommandConfig.func_71530_a((String[])args, (String[])this.sections.keySet().toArray(new String[0]));
                }
                if (("set".equals(args[1]) || "get".equals(args[1])) && this.sections.containsKey(args[2]) && !this.sections.get(args[2]).isEmpty()) {
                    String[] validValues;
                    Property property2;
                    if (args.length == 4) {
                        return CommandConfig.func_71530_a((String[])args, (String[])this.sections.get(args[2]).getOrderedValues().stream().map(property -> property.getName()).collect(Collectors.toList()).toArray(new String[0]));
                    }
                    if ("set".equals(args[1]) && (property2 = this.sections.get(args[2]).get(args[3])) != null && (validValues = property2.getValidValues()) != null && validValues.length > 0) {
                        return CommandConfig.func_71530_a((String[])args, (String[])validValues);
                    }
                }
            }
        }
        return Collections.emptyList();
    }
}

