/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.blockiterators.AbstractBlockIterator;
import com.enderio.core.common.util.blockiterators.CubicBlockIterator;
import crazypants.enderio.base.handler.darksteel.StateController;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.item.darksteel.ItemDarkSteelPickaxe;
import crazypants.enderio.base.item.darksteel.upgrade.explosive.ExplosiveUpgrade;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderio")
public class PlayerAOEAttributeHandler {
    @Nonnull
    public static final IAttribute AOE_XZ = new RangedAttribute(null, "enderio.aoe.xz", 0.0, 0.0, 16.0).func_111112_a(true);
    @Nonnull
    public static final IAttribute AOE_Y = new RangedAttribute(null, "enderio.aoe.y", 0.0, 0.0, 16.0).func_111112_a(true);
    @Nonnull
    public static final IAttribute AOE_XYZ = new RangedAttribute(null, "enderio.aoe.xyz", 0.0, 0.0, 16.0).func_111112_a(true);

    @SubscribeEvent
    public static void handleConstruct(@Nonnull EntityEvent.EntityConstructing event) {
        PlayerAOEAttributeHandler.handleAttributes((EntityEvent)event);
    }

    @SubscribeEvent
    public static void handleJoin(@Nonnull EntityJoinWorldEvent event) {
        PlayerAOEAttributeHandler.handleAttributes((EntityEvent)event);
    }

    private static void handleAttributes(@Nonnull EntityEvent event) {
        AbstractAttributeMap map;
        if (event.getEntity() instanceof EntityPlayer && NullHelper.untrust((Object)(map = ((EntityLivingBase)event.getEntity()).func_110140_aT()).func_111151_a(AOE_XZ)) == null) {
            map.func_111150_b(AOE_XZ).func_111128_a(0.0);
            map.func_111150_b(AOE_Y).func_111128_a(0.0);
            map.func_111150_b(AOE_XYZ).func_111128_a(0.0);
        }
    }

    public static boolean hasAOE(@Nonnull EntityPlayer player) {
        return StateController.isActive(player, ExplosiveUpgrade.INSTANCE) && (player.func_110148_a(AOE_XZ).func_111126_e() > 0.0 || player.func_110148_a(AOE_Y).func_111126_e() > 0.0 || player.func_110148_a(AOE_XYZ).func_111126_e() > 0.0);
    }

    @Nonnull
    public static AxisAlignedBB expandBBbyAOE(@Nonnull EntityPlayer player, @Nonnull AxisAlignedBB bb, RayTraceResult rtr) {
        int xz = (int)player.func_110148_a(AOE_XZ).func_111126_e();
        int y = (int)player.func_110148_a(AOE_Y).func_111126_e();
        int xyz = (int)player.func_110148_a(AOE_XYZ).func_111126_e();
        switch (rtr.field_178784_b) {
            case DOWN: {
                return bb.func_72314_b((double)xz, 0.0, (double)xz).func_72321_a(0.0, (double)y, 0.0).func_186662_g((double)xyz);
            }
            case UP: {
                return bb.func_72314_b((double)xz, 0.0, (double)xz).func_72321_a(0.0, (double)(-y), 0.0).func_186662_g((double)xyz);
            }
        }
        int shift = (double)BlockCoord.get((Entity)player).func_177984_a().func_177956_o() == bb.field_72338_b ? xz + xyz - 1 : 0;
        switch (rtr.field_178784_b) {
            case EAST: {
                return bb.func_72314_b(0.0, (double)xz, (double)xz).func_72321_a((double)(-y), 0.0, 0.0).func_186662_g((double)xyz).func_72317_d(0.0, (double)shift, 0.0);
            }
            case WEST: {
                return bb.func_72314_b(0.0, (double)xz, (double)xz).func_72321_a((double)y, 0.0, 0.0).func_186662_g((double)xyz).func_72317_d(0.0, (double)shift, 0.0);
            }
            case NORTH: {
                return bb.func_72314_b((double)xz, (double)xz, 0.0).func_72321_a(0.0, 0.0, (double)y).func_186662_g((double)xyz).func_72317_d(0.0, (double)shift, 0.0);
            }
            case SOUTH: {
                return bb.func_72314_b((double)xz, (double)xz, 0.0).func_72321_a(0.0, 0.0, (double)(-y)).func_186662_g((double)xyz).func_72317_d(0.0, (double)shift, 0.0);
            }
        }
        return bb.func_72314_b((double)xz, (double)xz, (double)xz).func_186662_g((double)xyz).func_72317_d(0.0, (double)shift, 0.0);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onHighlight(@Nonnull DrawBlockHighlightEvent event) {
        EntityPlayer player;
        RayTraceResult movingObjectPositionIn = event.getTarget();
        if (movingObjectPositionIn.field_72313_a == RayTraceResult.Type.BLOCK && (player = event.getPlayer()) != null && !player.func_70093_af() && PlayerAOEAttributeHandler.hasAOE(player)) {
            IBlockState iblockstate;
            BlockPos blockpos = movingObjectPositionIn.func_178782_a();
            World world = player.field_70170_p;
            if (world.func_175723_af().func_177746_a(blockpos) && (iblockstate = world.func_180495_p(blockpos)).func_185904_a() != Material.field_151579_a) {
                float partialTicks = event.getPartialTicks();
                double d3 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
                double d4 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
                double d5 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
                AxisAlignedBB origin = new AxisAlignedBB(blockpos);
                AxisAlignedBB bb = PlayerAOEAttributeHandler.expandBBbyAOE(player, origin, movingObjectPositionIn).func_186662_g((double)0.002f).func_72317_d(-d3, -d4, -d5);
                PlayerAOEAttributeHandler.drawSelectionBoundingBox(origin.func_186662_g((double)0.002f).func_72317_d(-d3, -d4, -d5), bb, 0.25f, 0.0f, 0.0f, 0.4f);
            }
        }
    }

    @Nullable
    public static RayTraceResult rayTrace(@Nonnull EntityPlayer player) {
        return ((ItemDarkSteelPickaxe)ModObject.itemDarkSteelPickaxe.getItemNN()).func_77621_a(player.field_70170_p, player, false);
    }

    public static Iterator<BlockPos> getAOE(@Nonnull BlockPos origin, @Nonnull EntityPlayer player) {
        RayTraceResult movingObjectPositionIn = PlayerAOEAttributeHandler.rayTrace(player);
        if (movingObjectPositionIn != null && movingObjectPositionIn.field_72313_a == RayTraceResult.Type.BLOCK && origin.equals((Object)movingObjectPositionIn.func_178782_a())) {
            return new BBIterator(origin, new BoundingBox(PlayerAOEAttributeHandler.expandBBbyAOE(player, new AxisAlignedBB(origin), movingObjectPositionIn)));
        }
        return new AbstractBlockIterator(origin){

            public BlockPos next() {
                return null;
            }

            public boolean hasNext() {
                return false;
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawSelectionBoundingBox(@Nonnull AxisAlignedBB origin, @Nonnull AxisAlignedBB box, float red, float green, float blue, float alpha) {
        double minXO = origin.field_72340_a;
        double minYO = origin.field_72338_b;
        double minZO = origin.field_72339_c;
        double maxXO = origin.field_72336_d;
        double maxYO = origin.field_72337_e;
        double maxZO = origin.field_72334_f;
        double minX = box.field_72340_a;
        double minY = box.field_72338_b;
        double minZ = box.field_72339_c;
        double maxX = box.field_72336_d;
        double maxY = box.field_72337_e;
        double maxZ = box.field_72334_f;
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b(minXO, minYO, minZO).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(minX, minY, minZ).func_181666_a(red, green, blue, alpha * 0.5f).func_181675_d();
        bufferbuilder.func_181662_b(maxX, minY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(maxX, minY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(minX, minY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(minX, minY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(minX, maxY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(maxX, maxY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(maxX, maxY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(minX, maxY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(minX, maxY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(minXO, maxYO, minZO).func_181666_a(red, green, blue, alpha * 0.5f).func_181675_d();
        bufferbuilder.func_181662_b(minX, maxY, maxZ).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(minX, minY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(minXO, minYO, maxZO).func_181666_a(red, green, blue, alpha * 0.5f).func_181675_d();
        bufferbuilder.func_181662_b(maxX, maxY, maxZ).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(maxX, minY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(maxXO, minYO, maxZO).func_181666_a(red, green, blue, alpha * 0.5f).func_181675_d();
        bufferbuilder.func_181662_b(maxX, maxY, minZ).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(maxX, minY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(maxXO, minYO, minZO).func_181666_a(red, green, blue, alpha * 0.5f).func_181675_d();
        bufferbuilder.func_181662_b(maxXO, maxYO, minZO).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(maxX, maxY, minZ).func_181666_a(red, green, blue, alpha * 0.5f).func_181675_d();
        bufferbuilder.func_181662_b(minXO, maxYO, maxZO).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(minX, maxY, maxZ).func_181666_a(red, green, blue, alpha * 0.5f).func_181675_d();
        bufferbuilder.func_181662_b(maxXO, maxYO, maxZO).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(maxX, maxY, maxZ).func_181666_a(red, green, blue, alpha * 0.5f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    private static class BBIterator
    extends CubicBlockIterator {
        public BBIterator(@Nonnull BlockPos origin, @Nonnull BoundingBox bb) {
            super(origin, (int)bb.field_72340_a, (int)bb.field_72338_b, (int)bb.field_72339_c, (int)bb.field_72336_d - 1, (int)bb.field_72337_e - 1, (int)bb.field_72334_f - 1);
        }

        @Nonnull
        public BlockPos next() {
            BlockPos next = super.next();
            return next.equals((Object)this.base) && this.hasNext() ? super.next() : next;
        }
    }
}

