/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.killera;

import com.enderio.core.common.interfaces.ICreeperTarget;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.UserIdent;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.base.machine.fakeplayer.FakePlayerEIO;
import crazypants.enderio.base.power.wireless.WirelessChargedLocation;
import crazypants.enderio.machines.config.config.KillerJoeConfig;
import crazypants.enderio.machines.machine.killera.InventoryKillerJoe;
import crazypants.enderio.machines.machine.killera.TileKillerJoe;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.StringUtils;

@Mod.EventBusSubscriber(modid="enderiomachines")
class FakePlayerKillerJoe
extends FakePlayerEIO
implements ICreeperTarget {
    private static final UUID uuid = UUID.fromString("3baa66fa-a69a-11e4-89d3-123b93f75cba");
    private static final GameProfile DUMMY_PROFILE = new GameProfile(uuid, "[Killer Joe]");
    @Nonnull
    private final TileKillerJoe te;
    protected WirelessChargedLocation chargedLocation;
    @Nonnull
    ItemStack prevWeapon = ItemStack.field_190927_a;

    public FakePlayerKillerJoe(@Nonnull TileKillerJoe te, @Nonnull UserIdent owner) {
        super(te.func_145831_w(), te.getLocation(), FakePlayerKillerJoe.makeGameProfile(owner));
        this.te = te;
        this.setOwner(owner);
        this.field_71071_by = new InventoryKillerJoe((EntityPlayer)this, te);
        if (!this.field_70170_p.field_72995_K) {
            this.chargedLocation = new WirelessChargedLocation((TileEntity)te);
        }
    }

    @Nonnull
    private static GameProfile makeGameProfile(UserIdent owner) {
        return owner == UserIdent.NOBODY || StringUtils.isBlank((CharSequence)owner.getPlayerName()) ? DUMMY_PROFILE : new GameProfile(uuid, "[" + owner.getPlayerName() + "'s Killer Joe]");
    }

    public void func_70071_h_() {
        ItemStack prev = this.prevWeapon;
        ItemStack cur = this.func_184614_ca();
        if (!ItemStack.func_77989_b((ItemStack)cur, (ItemStack)prev)) {
            if (!prev.func_190926_b()) {
                this.func_110140_aT().func_111148_a(prev.func_111283_C(EntityEquipmentSlot.MAINHAND));
            }
            if (!cur.func_190926_b()) {
                this.func_110140_aT().func_111147_b(cur.func_111283_C(EntityEquipmentSlot.MAINHAND));
            }
            this.prevWeapon = cur.func_77946_l();
        }
        if (this.chargedLocation != null && this.chargedLocation.chargeItems((NonNullList<ItemStack>)new NNList((Object[])new ItemStack[]{cur}))) {
            this.te.func_70296_d();
        }
        ++this.field_184617_aD;
    }

    public int getTicksSinceLastSwing() {
        return this.field_184617_aD;
    }

    public void func_71059_n(@Nonnull Entity targetEntity) {
        this.field_70122_E = true;
        this.faceEntity(targetEntity);
        super.func_71059_n(targetEntity);
    }

    public void faceEntity(Entity entityIn) {
        double d1;
        double d0 = entityIn.field_70165_t - this.field_70165_t;
        double d2 = entityIn.field_70161_v - this.field_70161_v;
        if (entityIn instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)entityIn;
            d1 = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (this.field_70163_u + (double)this.func_70047_e());
        } else {
            d1 = (entityIn.func_174813_aQ().field_72338_b + entityIn.func_174813_aQ().field_72337_e) / 2.0 - (this.field_70163_u + (double)this.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        this.field_70125_A = MathHelper.func_76142_g((float)((float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232))));
        this.field_70177_z = MathHelper.func_76142_g((float)((float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f));
    }

    public boolean isCreeperTarget(@Nonnull EntityCreeper swellingCreeper) {
        return (Boolean)KillerJoeConfig.killerProvokesCreeperExplosions.get();
    }

    @SubscribeEvent
    public static void onSummonAid(ZombieEvent.SummonAidEvent event) {
        if (event.getAttacker() instanceof FakePlayerKillerJoe && !((Boolean)KillerJoeConfig.killerProvokesZombieHordes.get()).booleanValue()) {
            event.setResult(Event.Result.DENY);
        }
    }
}

