/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;

public class CommandTBBind
extends TombstoneCommand {
    private static final String BIND_LOCATIONS_NBT_LIST = "tb_bind_locations";
    private static final String BIND_LOCATION_NBT_TAG = "location";
    private static final String BIND_LOCATION_ID_NBT_BYTE = "bind_id";
    private static final int BIND_ID_MIN = 1;
    private static final int BIND_ID_MAX = 5;
    private static final BiPredicate<NBTBase, Integer> IS_BIND_ID = (nbt, bindId) -> bindId.intValue() == ((NBTTagCompound)nbt).func_74771_c(BIND_LOCATION_ID_NBT_BYTE);

    public String func_71517_b() {
        return "tbbind";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (ConfigTombstone.general.cooldownTeleportBind < 0) {
            throw LangKey.COMMAND_EXCEPTION_DISABLED.asCommandException(new Object[0]);
        }
        if (args.length == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        SubCommand action = SubCommand.fromString(args[0]);
        if (action == null) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        switch (action) {
            case SHOW: {
                this.showBinds(sender);
                break;
            }
            case SET: {
                this.setBind(sender, args.length == 1 ? 0 : CommandTBBind.func_175764_a((String)args[1], (int)1, (int)5));
                break;
            }
            case TELEPORT: {
                this.teleportBind(server, sender, this.getOrThrowLocation(CommandTBBind.func_71521_c((ICommandSender)sender), args.length == 1 ? 0 : CommandTBBind.func_175764_a((String)args[1], (int)1, (int)5)));
            }
        }
    }

    @Override
    public int func_82362_a() {
        return 0;
    }

    private void showBinds(ICommandSender sender) throws CommandException {
        EntityPlayerMP player = CommandTBBind.func_71521_c((ICommandSender)sender);
        NonNullList<Location> locations = this.getLocationList(player);
        if (locations.stream().allMatch(Location::isOrigin)) {
            throw LangKey.COMMAND_EXCEPTION_NO_BIND_LOCATION.asCommandException(new Object[0]);
        }
        IntStream.range(0, locations.size()).forEach(i -> {
            Location location = (Location)locations.get(i);
            if (!location.isOrigin()) {
                player.func_145747_a((ITextComponent)new TextComponentString(i + 1 + " -> {" + location.x + ", " + location.y + ", " + location.z + ", " + location.dim + "}"));
            }
        });
    }

    private void teleportBind(MinecraftServer server, ICommandSender sender, Location location) throws CommandException {
        EntityPlayerMP player = CommandTBBind.func_71521_c((ICommandSender)sender);
        CommandTBBind.checkAlive((Entity)player);
        CommandTBBind.checkNotSpectator((EntityPlayer)player);
        ITBCapability cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
        if (cap == null) {
            throw new CommandException(LangKey.COMMAND_EXCEPTION_CAP_NULL.getKey(), new Object[0]);
        }
        int cd = cap.getCooldownToTeleportBind(player);
        if (cd > 0) {
            int[] timeArray = TimeHelper.getTimeArray(cd);
            player.func_145747_a(LangKey.MESSAGE_COMMAND_IN_COOLDOWN.getTranslation(String.format("%02d", timeArray[0]), String.format("%02d", timeArray[1]), String.format("%02d", timeArray[2])));
            return;
        }
        cap.setCooldownToTeleportBind(TimeHelper.worldTicks(player.field_70170_p) + (long)TimeHelper.tickFromMinute(ConfigTombstone.general.cooldownTeleportBind));
        if (!Helper.isValidDimension(location.dim)) {
            throw new CommandException(LangKey.COMMAND_EXCEPTION_NO_DIMENSION.getKey(), new Object[0]);
        }
        WorldServer world = server.func_71218_a(location.dim);
        Location spawnPlace = new SpawnHelper(world, location.getPos()).findSpawnPlace();
        if (spawnPlace.isOrigin()) {
            throw LangKey.COMMAND_EXCEPTION_NO_SPAWN.asCommandException(new Object[0]);
        }
        EntityPlayerMP newEntity = Helper.teleportEntity(player, spawnPlace);
        if (EntityHelper.isValidPlayer((Entity)newEntity)) {
            newEntity.func_145747_a(LangKey.MESSAGE_TELEPORT_SUCCESS.getTranslationWithStyle(StyleType.MESSAGE_SPELL, new Object[0]));
        }
        CommandTBBind.func_152373_a((ICommandSender)sender, (ICommand)this, (String)LangKey.MESSAGE_LOG_TELEPORT_SUCCESS.getKey(), (Object[])new Object[]{newEntity.func_70005_c_(), spawnPlace.x, spawnPlace.y, spawnPlace.z, spawnPlace.dim});
    }

    private void setBind(ICommandSender sender, int bindId) throws CommandException {
        Location location;
        EntityPlayerMP player = CommandTBBind.func_71521_c((ICommandSender)sender);
        NBTTagCompound persistentTag = EntityHelper.getPersistentTag((EntityPlayer)player);
        NBTTagList locationList = persistentTag.func_150295_c(BIND_LOCATIONS_NBT_LIST, 10);
        if (!this.findFirstLocationInListNBT(locationList, arg_0 -> CommandTBBind.lambda$setBind$1(location = new Location((Entity)player), arg_0)).isOrigin()) {
            throw LangKey.COMMAND_EXCEPTION_EXISTING_BIND_LOCATION.asCommandException(new Object[0]);
        }
        if (bindId == 0) {
            byte id = this.getFirstEmptyIdInListNBT(locationList);
            if (id == -1) {
                this.setOrReplaceLocationInListNBT(locationList, location, bindId).func_74774_a(BIND_LOCATION_ID_NBT_BYTE, (byte)1);
            } else {
                NBTTagCompound nbt = NBTStackHelper.setLocation(new NBTTagCompound(), BIND_LOCATION_NBT_TAG, location);
                nbt.func_74774_a(BIND_LOCATION_ID_NBT_BYTE, id);
                locationList.func_74742_a((NBTBase)nbt);
            }
        } else {
            this.setOrReplaceLocationInListNBT(locationList, location, bindId).func_74774_a(BIND_LOCATION_ID_NBT_BYTE, (byte)bindId);
        }
        persistentTag.func_74782_a(BIND_LOCATIONS_NBT_LIST, (NBTBase)locationList);
        player.func_145747_a(LangKey.MESSAGE_BIND_LOCATION.getTranslation(new Object[0]));
    }

    private Byte getFirstEmptyIdInListNBT(NBTTagList locationList) {
        byte minId = -1;
        for (int i = 0; i < locationList.func_74745_c(); ++i) {
            byte id = ((NBTTagCompound)locationList.func_179238_g(i)).func_74771_c(BIND_LOCATION_ID_NBT_BYTE);
            if (id < 1 || id > 5) continue;
            minId = id;
        }
        return minId;
    }

    private NBTTagCompound setOrReplaceLocationInListNBT(NBTTagList locationList, Location location, int bindId) {
        NBTTagCompound nbt = null;
        for (int i = 0; i < locationList.func_74745_c(); ++i) {
            NBTTagCompound aNbt = (NBTTagCompound)locationList.func_179238_g(i);
            if (!IS_BIND_ID.test((NBTBase)aNbt, bindId)) continue;
            nbt = aNbt;
            break;
        }
        if (nbt == null) {
            NBTTagCompound aNbt = new NBTTagCompound();
            locationList.func_74742_a((NBTBase)aNbt);
            nbt = aNbt;
        }
        return NBTStackHelper.setLocation(nbt, BIND_LOCATION_NBT_TAG, location);
    }

    private Location getOrThrowLocation(EntityPlayerMP player, int bindId) throws CommandException {
        NBTTagCompound persistentTag;
        if (bindId < 0 || bindId > 5 || !(persistentTag = EntityHelper.getPersistentTag((EntityPlayer)player)).func_150297_b(BIND_LOCATIONS_NBT_LIST, 9)) {
            throw LangKey.COMMAND_EXCEPTION_INVALID_LOCATION.asCommandException(new Object[0]);
        }
        NBTTagList locationList = persistentTag.func_150295_c(BIND_LOCATIONS_NBT_LIST, 10);
        Location location = this.findFirstLocationInListNBT(locationList, bindId == 0 ? nbt -> true : nbt -> IS_BIND_ID.test((NBTBase)nbt, bindId));
        if (location.isOrigin()) {
            throw LangKey.COMMAND_EXCEPTION_NO_BIND_LOCATION.asCommandException(new Object[0]);
        }
        return location;
    }

    private Location findFirstLocationInListNBT(NBTTagList locationList, Predicate<NBTBase> predic) {
        for (int i = 0; i < locationList.func_74745_c(); ++i) {
            NBTTagCompound nbt = (NBTTagCompound)locationList.func_179238_g(i);
            if (!predic.test((NBTBase)nbt)) continue;
            return NBTStackHelper.getLocation(nbt, BIND_LOCATION_NBT_TAG);
        }
        return Location.ORIGIN;
    }

    private NonNullList<Location> getLocationList(EntityPlayerMP player) {
        NBTTagCompound persistentTag = EntityHelper.getPersistentTag((EntityPlayer)player);
        NonNullList locationInstances = NonNullList.func_191197_a((int)5, (Object)Location.ORIGIN);
        if (persistentTag.func_150297_b(BIND_LOCATIONS_NBT_LIST, 9)) {
            NBTTagList locationList = persistentTag.func_150295_c(BIND_LOCATIONS_NBT_LIST, 10);
            HashMap<Integer, Boolean> dims = new HashMap<Integer, Boolean>();
            Iterator it = locationList.iterator();
            while (it.hasNext()) {
                NBTTagCompound data = (NBTTagCompound)it.next();
                Location location = NBTStackHelper.getLocation(data, BIND_LOCATION_NBT_TAG);
                if (!location.isOrigin() && dims.computeIfAbsent(location.dim, Helper::isValidDimension).booleanValue()) {
                    locationInstances.set(data.func_74771_c(BIND_LOCATION_ID_NBT_BYTE) - 1, (Object)location);
                    continue;
                }
                it.remove();
            }
        }
        return locationInstances;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        SubCommand action;
        if (args.length == 1) {
            return CommandTBBind.func_175762_a((String[])args, (Collection)Arrays.stream(SubCommand.values()).map(SubCommand::asString).collect(Collectors.toList()));
        }
        if (args.length == 2 && ((action = SubCommand.fromString(args[0])) == SubCommand.SET || action == SubCommand.TELEPORT)) {
            return CommandTBBind.func_175762_a((String[])args, (Collection)IntStream.rangeClosed(1, 5).mapToObj(String::valueOf).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ boolean lambda$setBind$1(Location location, NBTBase nbt) {
        return NBTStackHelper.getLocation((NBTTagCompound)nbt, BIND_LOCATION_NBT_TAG).equals(location);
    }

    static enum SubCommand {
        SHOW,
        SET,
        TELEPORT;

        private final String name = this.name().toLowerCase(Locale.US);

        String asString() {
            return this.name;
        }

        @Nullable
        static SubCommand fromString(String action) {
            return Arrays.stream(SubCommand.values()).filter(v -> v.asString().equals(action)).findFirst().orElse(null);
        }
    }
}

