/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.inventory.AccessInventoryGC;
import micdoodle8.mods.galacticraft.api.inventory.IInventoryGC;
import micdoodle8.mods.galacticraft.api.item.EnumExtendedInventorySlot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import ovh.corail.tombstone.compatibility.IEquipableCompat;

public class CompatibilityGalactiCraft
implements IEquipableCompat {
    public static final CompatibilityGalactiCraft instance = new CompatibilityGalactiCraft();

    private CompatibilityGalactiCraft() {
    }

    @Override
    public boolean autoEquip(ItemStack stack, EntityPlayer player) {
        try {
            IInventoryGC galacInvent = AccessInventoryGC.getGCInventoryForPlayer((EntityPlayerMP)((EntityPlayerMP)player));
            if (galacInvent == null) {
                return false;
            }
            for (int slot = 0; slot < galacInvent.func_70302_i_(); ++slot) {
                if (!galacInvent.func_70301_a(slot).func_190926_b() || !this.canEquipStackInSlot(stack, slot)) continue;
                galacInvent.func_70299_a(slot, stack.func_77946_l());
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean canEquipStackInSlot(ItemStack stack, int slot) {
        EnumExtendedInventorySlot typeSlot = this.getTypeFromSlot(slot);
        return typeSlot != null && GalacticraftRegistry.findMatchingGearID((ItemStack)stack, (EnumExtendedInventorySlot)typeSlot) >= 0;
    }

    private EnumExtendedInventorySlot getTypeFromSlot(int slot) {
        switch (slot) {
            case 0: {
                return EnumExtendedInventorySlot.MASK;
            }
            case 1: {
                return EnumExtendedInventorySlot.GEAR;
            }
            case 2: {
                return EnumExtendedInventorySlot.LEFT_TANK;
            }
            case 3: {
                return EnumExtendedInventorySlot.RIGHT_TANK;
            }
            case 4: {
                return EnumExtendedInventorySlot.PARACHUTE;
            }
            case 5: {
                return EnumExtendedInventorySlot.FREQUENCY_MODULE;
            }
            case 6: {
                return EnumExtendedInventorySlot.THERMAL_HELMET;
            }
            case 7: {
                return EnumExtendedInventorySlot.THERMAL_CHESTPLATE;
            }
            case 8: {
                return EnumExtendedInventorySlot.THERMAL_LEGGINGS;
            }
            case 9: {
                return EnumExtendedInventorySlot.THERMAL_BOOTS;
            }
            case 10: {
                return EnumExtendedInventorySlot.SHIELD_CONTROLLER;
            }
        }
        return null;
    }
}

