/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.LinkedList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;

public class TeleportUtils {
    public static Entity teleportEntity(Entity entity, int targetDim, double xCoord, double yCoord, double zCoord) {
        if (entity.field_70170_p.field_72995_K || entity.field_70128_L) {
            return entity;
        }
        int sourceDim = entity.field_70170_p.field_73011_w.getDimension();
        if (!entity.func_184207_aI() && !entity.func_184218_aH()) {
            return TeleportUtils.handleEntityTeleport(entity, sourceDim, targetDim, xCoord, yCoord, zCoord);
        }
        PassengerHelper passengerHelper = new PassengerHelper(entity.func_184208_bv());
        passengerHelper.teleport(sourceDim, targetDim, xCoord, yCoord, zCoord);
        passengerHelper.remountRiders();
        passengerHelper.updateClients();
        return Optional.ofNullable(passengerHelper.getPassenger(entity)).map(e -> ((PassengerHelper)e).entity).orElse(entity);
    }

    private static Entity handleEntityTeleport(Entity entity, int sourceDim, int targetDim, double xCoord, double yCoord, double zCoord) {
        boolean interDimensional;
        if (entity.field_70128_L) {
            return entity;
        }
        boolean bl = interDimensional = sourceDim != targetDim;
        if (interDimensional) {
            return Optional.ofNullable(entity.changeDimension(targetDim, (ITeleporter)new CustomTeleporter(xCoord, yCoord, zCoord))).orElse(entity);
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            player.field_71135_a.func_147364_a(xCoord, yCoord, zCoord, player.field_70177_z, player.field_70125_A);
            player.func_70034_d(player.field_70759_as);
            return player;
        }
        entity.func_70012_b(xCoord, yCoord, zCoord, entity.field_70177_z, entity.field_70125_A);
        entity.func_70034_d(entity.field_70177_z);
        return entity;
    }

    private static class PassengerHelper {
        private Entity entity;
        private final LinkedList<PassengerHelper> passengers = new LinkedList();
        private double offsetX;
        private double offsetY;
        private double offsetZ;

        PassengerHelper(Entity entity) {
            this.entity = entity;
            if (entity.func_184218_aH()) {
                assert (entity.func_184187_bx() != null);
                this.offsetX = entity.field_70165_t - entity.func_184187_bx().field_70165_t;
                this.offsetY = entity.field_70163_u - entity.func_184187_bx().field_70163_u;
                this.offsetZ = entity.field_70161_v - entity.func_184187_bx().field_70161_v;
            }
            for (Entity passenger : entity.func_184188_bt()) {
                this.passengers.add(new PassengerHelper(passenger));
            }
        }

        void teleport(int sourceDim, int targetDim, double xCoord, double yCoord, double zCoord) {
            this.entity.func_184226_ay();
            this.entity = TeleportUtils.handleEntityTeleport(this.entity, sourceDim, targetDim, xCoord, yCoord, zCoord);
            for (PassengerHelper passenger : this.passengers) {
                passenger.teleport(sourceDim, targetDim, xCoord, yCoord, zCoord);
            }
        }

        void remountRiders() {
            if (this.entity == null) {
                return;
            }
            if (this.entity.func_184218_aH()) {
                this.entity.func_70012_b(this.entity.field_70165_t + this.offsetX, this.entity.field_70163_u + this.offsetY, this.entity.field_70161_v + this.offsetZ, this.entity.field_70177_z, this.entity.field_70125_A);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.entity.func_184205_a(this.entity, true);
                passenger.remountRiders();
            }
        }

        void updateClients() {
            if (this.entity instanceof EntityPlayerMP) {
                this.updateClient((EntityPlayerMP)this.entity);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        private void updateClient(EntityPlayerMP playerMP) {
            if (this.entity.func_184207_aI()) {
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketSetPassengers(this.entity));
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        @Nullable
        PassengerHelper getPassenger(Entity passenger) {
            if (this.entity == passenger) {
                return this;
            }
            for (PassengerHelper rider : this.passengers) {
                PassengerHelper re = rider.getPassenger(passenger);
                if (re == null) continue;
                return re;
            }
            return null;
        }
    }

    private static class CustomTeleporter
    implements ITeleporter {
        private final Vec3d destination;

        CustomTeleporter(double destX, double destY, double destZ) {
            this.destination = new Vec3d(destX, destY, destZ);
        }

        public void placeEntity(World world, Entity entity, float yaw) {
            entity.func_70012_b(this.destination.field_72450_a, this.destination.field_72448_b, this.destination.field_72449_c, entity.field_70177_z, entity.field_70125_A);
            entity.field_70179_y = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70159_w = 0.0;
        }
    }
}

