/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.command.CommandTBTeleportHome;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfHome
extends ItemTablet {
    public ItemTabletOfHome() {
        super("tablet_of_home");
        this.func_185043_a(new ResourceLocation("ancient"), (stack, worldIn, entityIn) -> this.isAncient(stack) ? 1.0f : 0.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            this.addItemDesc(list);
            boolean isAncient = this.isAncient(stack);
            if (isAncient) {
                this.addItemDesc(list, "_ancient", new Object[0]);
            }
            this.addItemUse(list, !this.isEnchanted(stack) ? "1" : "2", new Object[0]);
            this.addInfoInBeta(list);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        return ConfigTombstone.allowedMagicItems.allowTabletOfHome;
    }

    @Override
    protected boolean doEffects(World world, EntityPlayerMP player, ItemStack stack) {
        boolean isSameDim;
        Pair<World, BlockPos> respawnPoint = CommandTBTeleportHome.getRespawnPoint((EntityPlayer)player);
        if (respawnPoint.getLeft() == null || respawnPoint.getRight() == null) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        boolean bl = isSameDim = respawnPoint.getLeft() == world;
        if (!isSameDim && !ConfigTombstone.general.teleportDim) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        Location location = new SpawnHelper((WorldServer)respawnPoint.getLeft(), (BlockPos)respawnPoint.getRight()).findSpawnPlace();
        if (location.isOrigin()) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        CallbackHandler.addCallback(1, () -> {
            boolean isAncient = this.isAncient(stack);
            AxisAlignedBB area = isAncient ? player.func_174813_aQ().func_72314_b(3.0, 0.0, 3.0) : null;
            EntityPlayerMP newPlayer = Helper.teleportEntity(player, location);
            if (isAncient) {
                List entities = world.func_72839_b((Entity)player, area);
                entities.forEach(entity -> Helper.teleportEntity(entity, new Location((Entity)newPlayer)));
            }
            newPlayer.func_145747_a(LangKey.MESSAGE_TELEPORT_SUCCESS.getTranslation(new Object[0]));
            ModTriggers.USE_HOME.trigger(player);
        });
        return true;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        NBTStackHelper.setBoolean(stack, "enchant", true);
        this.setUseCount(stack, this.getUseMax());
        return true;
    }
}

