/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.filter;

import cofh.core.util.helpers.ItemHelper;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public class ItemFilter
implements INBTSerializable<NBTTagCompound> {
    private ItemStack[] items;
    private TIntHashSet oreIDs;
    private boolean[] flags = new boolean[]{false, false, false, false};

    public ItemFilter(int size) {
        this.items = new ItemStack[size];
        Arrays.fill(this.items, ItemStack.field_190927_a);
        this.oreIDs = new TIntHashSet();
    }

    public void setFlag(int flag, boolean value) {
        this.flags[flag] = value;
    }

    public boolean getFlag(int flag) {
        return this.flags[flag];
    }

    public void setSlot(int index, ItemStack stack) {
        this.items[index] = stack;
        this.updateOreIDs();
    }

    public ItemStack getSlot(int index) {
        return this.items[index];
    }

    public ItemStack[] getItems() {
        return this.items;
    }

    public int getSize() {
        return this.items.length;
    }

    public void clear() {
        Arrays.fill(this.items, ItemStack.field_190927_a);
        this.oreIDs.clear();
    }

    public boolean matches(ItemStack stack) {
        boolean ret = this.flags[0];
        if (this.flags[1] && !this.oreIDs.isEmpty()) {
            List<Integer> ids = ItemHelper.oreProxy.getAllOreIDs(stack);
            for (Integer i : ids) {
                if (!this.oreIDs.contains(i.intValue())) continue;
                return ret;
            }
        }
        for (ItemStack item : this.items) {
            if (item.func_77973_b() != stack.func_77973_b() || this.flags[3] && item.func_77952_i() != stack.func_77952_i() || this.flags[2] && !ItemHelper.doNBTsMatch(item.func_77978_p(), stack.func_77978_p())) continue;
            return ret;
        }
        return !ret;
    }

    private void updateOreIDs() {
        this.oreIDs.clear();
        for (ItemStack item : this.items) {
            if (item.func_190926_b()) continue;
            this.oreIDs.addAll(ItemHelper.oreProxy.getAllOreIDs(item));
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i].func_190926_b()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Slot", i);
            this.items[i].func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
        nbt.func_74774_a("Flags", (byte)this.getFlagByte());
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            int slot = tag.func_74762_e("Slot");
            if (slot < 0 || slot >= this.items.length) continue;
            this.items[slot] = new ItemStack(tag);
        }
        this.setFlagByte(nbt.func_74771_c("Flags"));
        this.updateOreIDs();
    }

    public void setFlagByte(int value) {
        for (int i = 0; i < this.flags.length; ++i) {
            this.flags[i] = (value & 1 << i) != 0;
        }
    }

    public int getFlagByte() {
        int v = 0;
        for (int i = 0; i < this.flags.length; ++i) {
            if (!this.flags[i]) continue;
            v |= 1 << i;
        }
        return v;
    }
}

