/*
 * Decompiled with CFR 0.152.
 */
package jackyy.gunpowderlib.helper;

import jackyy.gunpowderlib.capability.FEStorageCapability;
import jackyy.gunpowderlib.helper.NBTHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.CapabilityEnergy;

public class EnergyHelper {
    public static final String ENERGY_NBT = "Energy";

    public static ItemStack setDefaultEnergyTag(ItemStack container, int energy) {
        if (!container.func_77942_o()) {
            container.func_77982_d(new NBTTagCompound());
        }
        container.func_77978_p().func_74768_a(ENERGY_NBT, energy);
        return container;
    }

    public static int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (!container.func_77942_o()) {
            EnergyHelper.setDefaultEnergyTag(container, 0);
        }
        int stored = EnergyHelper.getEnergyStored(container);
        int received = Math.min(EnergyHelper.getMaxEnergyStored(container) - stored, Math.min(EnergyHelper.getMaxEnergyStored(container) / 4, maxReceive));
        if (!simulate) {
            NBTHelper.setInt(container, ENERGY_NBT, stored += received);
        }
        return received;
    }

    public static int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77942_o() && !container.func_77978_p().func_74764_b(ENERGY_NBT)) {
            return 0;
        }
        int stored = EnergyHelper.getEnergyStored(container);
        int extracted = Math.min(stored, Math.min(EnergyHelper.getMaxEnergyStored(container) / 4, maxExtract));
        if (!simulate) {
            NBTHelper.setInt(container, ENERGY_NBT, stored -= extracted);
        }
        return extracted;
    }

    public static int getEnergyStored(ItemStack stack) {
        FEStorageCapability storage = (FEStorageCapability)stack.getCapability(CapabilityEnergy.ENERGY, null);
        return storage != null ? storage.getEnergyStored() : 0;
    }

    public static int getMaxEnergyStored(ItemStack stack) {
        FEStorageCapability storage = (FEStorageCapability)stack.getCapability(CapabilityEnergy.ENERGY, null);
        return storage != null ? storage.getMaxEnergyStored() : 0;
    }
}

