/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.mdecore.command;

import com.mattdahepic.mdecore.MDECore;
import com.mattdahepic.mdecore.command.ICommandLogic;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandNotFoundException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

public abstract class AbstractCommand
extends CommandBase {
    private Map<String, ICommandLogic> commands = new HashMap<String, ICommandLogic>();

    public abstract String func_71517_b();

    public void init(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)this);
    }

    public String getCommandSyntax(String name) {
        if (this.getCommandExists(name)) {
            return this.commands.get(name).getCommandSyntax();
        }
        return null;
    }

    public boolean registerCommandLogic(ICommandLogic commandLogic) {
        MDECore.logger.debug("Registering command " + commandLogic.getClass().getName());
        try {
            if (!this.commands.containsKey(commandLogic.getCommandName())) {
                this.commands.put(commandLogic.getCommandName(), commandLogic);
                return true;
            }
            return false;
        }
        catch (Error e) {
            MDECore.logger.fatal("Error initializing command " + commandLogic.getClass().getName() + ". Please report this to the mod author.");
            throw new RuntimeException(e);
        }
    }

    public Set<String> getCommandList() {
        return this.commands.keySet();
    }

    public int getCommandPermission(String command) {
        return this.getCommandExists(command) ? this.commands.get(command).getPermissionLevel() : Integer.MAX_VALUE;
    }

    public boolean getCommandExists(String command) {
        return this.commands.containsKey(command);
    }

    public boolean canUseCommand(ICommandSender sender, int requiredPermission, AbstractCommand baseCommand, String name) {
        if (this.getCommandExists(name)) {
            return sender.func_70003_b(requiredPermission, baseCommand.func_71517_b() + " " + name) || sender instanceof EntityPlayerMP && requiredPermission <= 0;
        }
        return false;
    }

    public int func_82362_a() {
        return -1;
    }

    public List func_71514_a() {
        return Collections.emptyList();
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " help";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        ICommandLogic command;
        if (args.length < 1) {
            args = new String[]{"help"};
        }
        if ((command = this.commands.get(args[0])) != null) {
            if (this.canUseCommand(sender, command.getPermissionLevel(), this, command.getCommandName())) {
                command.handleCommand(server, sender, args);
                return;
            }
            throw new CommandException("commands.generic.permission", new Object[0]);
        }
        AbstractCommand.throwNoCommand();
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return AbstractCommand.func_175762_a((String[])args, this.commands.keySet());
        }
        if (this.commands.containsKey(args[0])) {
            return this.commands.get(args[0]).getTabCompletionList(server, sender, args, pos);
        }
        return null;
    }

    public static List<String> getPlayerNamesStartingWithLastArg(MinecraftServer server, String[] args) {
        return CommandBase.func_71530_a((String[])args, (String[])server.func_184103_al().func_72369_d());
    }

    public static void throwUsages(ICommandLogic command) throws WrongUsageException {
        throw new WrongUsageException(command.getCommandSyntax(), new Object[0]);
    }

    public static void throwNoPlayer(String name) throws PlayerNotFoundException {
        throw new PlayerNotFoundException(name);
    }

    public static void throwInvalidNumber(String notNumber) throws NumberInvalidException {
        throw new NumberInvalidException("commands.generic.num.invalid", new Object[]{notNumber});
    }

    public static void throwNoWorld() throws CommandException {
        throw new CommandException("Specified world not found!", new Object[0]);
    }

    public static void throwNoCommand() throws CommandNotFoundException {
        throw new CommandNotFoundException();
    }

    public static boolean doesCommandExist(MinecraftServer server, String commandName) {
        return server.field_71321_q.func_71555_a().containsKey(commandName);
    }
}

