/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.mdecore.command;

import com.mattdahepic.mdecore.command.AbstractCommand;
import com.mattdahepic.mdecore.command.ICommandLogic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public abstract class AbstractHelpLogic
implements ICommandLogic {
    public abstract AbstractCommand getBaseCommand();

    @Override
    public String getCommandName() {
        return "help";
    }

    @Override
    public int getPermissionLevel() {
        return -1;
    }

    @Override
    public String getCommandSyntax() {
        return String.format("/" + this.getBaseCommand().func_71517_b() + " help <command>", new Object[0]);
    }

    @Override
    public void handleCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        switch (args.length) {
            case 1: {
                StringBuilder output = new StringBuilder("Available commands are: ");
                ArrayList<String> commandList = new ArrayList<String>(this.getBaseCommand().getCommandList());
                Collections.sort(commandList, String.CASE_INSENSITIVE_ORDER);
                String baseCommand = "/" + this.getBaseCommand().func_71517_b() + " ";
                int commands = 0;
                for (int i = 0; i < commandList.size() - 1; ++i) {
                    String name = (String)commandList.get(i);
                    if (!this.getBaseCommand().canUseCommand(sender, this.getBaseCommand().getCommandPermission(name), this.getBaseCommand(), name)) continue;
                    output.append(baseCommand + TextFormatting.YELLOW + (String)commandList.get(i) + TextFormatting.WHITE + ", ");
                    ++commands;
                }
                if (commands > 0) {
                    output.delete(output.length() - 2, output.length());
                }
                String name = (String)commandList.get(commandList.size() - 1);
                if (this.getBaseCommand().canUseCommand(sender, this.getBaseCommand().getCommandPermission(name), this.getBaseCommand(), name)) {
                    if (commands > 0) {
                        output.append(" and ");
                    }
                    output.append(baseCommand + TextFormatting.YELLOW + name + TextFormatting.WHITE + ".");
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(output.toString()));
                break;
            }
            default: {
                String commandName = args[1];
                if (this.getBaseCommand().getCommandExists(commandName)) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Usage: " + TextFormatting.RESET + this.getBaseCommand().getCommandSyntax(commandName)));
                    break;
                }
                AbstractCommand.throwNoCommand();
            }
        }
    }

    @Override
    public List<String> getTabCompletionList(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 2) {
            return CommandBase.func_175762_a((String[])args, this.getBaseCommand().getCommandList());
        }
        return null;
    }
}

