/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.mdecore.command.logic;

import com.mattdahepic.mdecore.command.ICommandLogic;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;

public class KillAllLogic
implements ICommandLogic {
    public static KillAllLogic instance = new KillAllLogic();

    @Override
    public String getCommandName() {
        return "killall";
    }

    @Override
    public int getPermissionLevel() {
        return 2;
    }

    @Override
    public String getCommandSyntax() {
        return "/mde killall [partial name]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        int killCount = 0;
        HashMap<String, Integer> names = new HashMap<String, Integer>();
        String target = null;
        boolean all = false;
        if (args.length > 1) {
            target = args[1].toLowerCase();
            all = "*".equals(target);
        }
        WorldServer[] worldServerArray = server.field_71305_c;
        synchronized (server.field_71305_c) {
            for (WorldServer world : server.field_71305_c) {
                for (Entity entity : world.field_72996_f) {
                    if (entity == null || entity instanceof EntityPlayer) continue;
                    String entityName = EntityList.func_75621_b((Entity)entity);
                    if (target != null || all) {
                        if (!all && (entityName == null || !entityName.toLowerCase(Locale.US).contains(target))) continue;
                        names.put(entityName, names.get(entityName) != null ? (Integer)names.get(entityName) + 1 : 1);
                        ++killCount;
                        world.func_72900_e(entity);
                        continue;
                    }
                    if (!(entity instanceof IMob)) continue;
                    if (entityName == null) {
                        entityName = entity.getClass().getName();
                    }
                    names.put(entityName, names.get(entityName) != null ? (Integer)names.get(entityName) + 1 : 1);
                    ++killCount;
                    world.func_72900_e(entity);
                }
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            if (killCount > 0) {
                String finalNames = "";
                for (String name : names.keySet()) {
                    finalNames = finalNames + TextFormatting.RED + names.get(name) + TextFormatting.WHITE + "x" + TextFormatting.YELLOW + name + TextFormatting.WHITE + ", ";
                }
                finalNames = finalNames.substring(0, finalNames.length() - 2);
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format(target != null ? "Removed %d entities. (%s)" : "Removed %d hostile mobs. (%s)", killCount, finalNames)));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(target != null ? "No matching entities found!" : "No hostile mobs found!"));
            }
            return;
        }
    }

    @Override
    public List<String> getTabCompletionList(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return null;
    }
}

