/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.mdecore.helpers;

import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TeleportHelper {
    public static void transferPlayerToDimension(EntityPlayerMP player, int dimension, PlayerList list) {
        if (!player.field_70170_p.field_72995_K) {
            int oldDim = player.field_71093_bK;
            WorldServer worldServerOld = list.func_72365_p().func_71218_a(oldDim);
            WorldServer worldServerNew = list.func_72365_p().func_71218_a(dimension);
            player.field_71093_bK = dimension;
            player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(dimension, worldServerNew.func_175659_aa(), worldServerNew.func_175624_G(), player.field_71134_c.func_73081_b()));
            if (player.func_184207_aI()) {
                player.func_184210_p();
            }
            if (player.func_184218_aH()) {
                player.func_184187_bx().func_184210_p();
            }
            worldServerOld.func_72973_f((Entity)player);
            player.field_70128_L = false;
            TeleportHelper.transferEntityToWorld((Entity)player, worldServerOld, worldServerNew);
            list.func_72375_a(player, worldServerOld);
            player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
            player.field_71134_c.func_73080_a(worldServerNew);
            list.func_72354_b(player, worldServerNew);
            list.func_72385_f(player);
            for (PotionEffect effect : player.func_70651_bq()) {
                player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), effect));
            }
            worldServerOld.func_82742_i();
            worldServerNew.func_82742_i();
            FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, oldDim, dimension);
        }
    }

    public static void transferEntityToWorld(Entity entity, WorldServer oldWorld, WorldServer newWorld) {
        double moveFactor = oldWorld.field_73011_w.getMovementFactor() / newWorld.field_73011_w.getMovementFactor();
        double x = entity.field_70165_t * moveFactor;
        double z = entity.field_70161_v * moveFactor;
        x = MathHelper.func_151237_a((double)x, (double)-2.9999872E7, (double)2.9999872E7);
        z = MathHelper.func_151237_a((double)z, (double)-2.9999872E7, (double)2.9999872E7);
        entity.func_70029_a((World)newWorld);
        entity.func_70012_b(x, entity.field_70163_u, z, entity.field_70177_z, entity.field_70125_A);
        newWorld.func_72838_d(entity);
        newWorld.func_72866_a(entity, false);
    }

    public static void sendPlayerToSpawnInCurrentWorld(ICommandSender sender) {
        World world = sender.func_130014_f_();
        BlockPos spawn = world.func_175694_M();
        double spawnX = (double)spawn.func_177958_n() + 0.5;
        double spawnY = (double)spawn.func_177956_o() + 0.5;
        double spawnZ = (double)spawn.func_177952_p() + 0.5;
        while (!world.func_175678_i(new BlockPos(spawnX, spawnY - 1.0, spawnZ))) {
            spawnY += 1.0;
        }
        try {
            CommandBase.func_71521_c((ICommandSender)sender).func_70634_a(spawnX, spawnY, spawnZ);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isSafeLandingPosition(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a && world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a && world.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }
}

