/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.container.storage;

import cofh.api.core.ISecurable;
import cofh.core.gui.container.ContainerInventoryItem;
import cofh.core.gui.slot.ISlotValidator;
import cofh.core.gui.slot.SlotLocked;
import cofh.core.gui.slot.SlotValidated;
import cofh.core.network.PacketCore;
import cofh.core.util.CoreUtils;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.SecurityHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.gui.slot.SlotSatchelCreative;
import cofh.thermalexpansion.gui.slot.SlotSatchelVoid;
import cofh.thermalexpansion.item.ItemSatchel;
import com.mojang.authlib.GameProfile;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;

@ChestContainer
public class ContainerSatchel
extends ContainerInventoryItem
implements ISecurable,
ISlotValidator {
    static final String NAME = "item.thermalexpansion.satchel.name";
    boolean isCreative;
    boolean isVoid;
    int storageIndex;
    int rowSize;

    public ContainerSatchel(ItemStack stack, InventoryPlayer inventory) {
        super(stack, inventory);
        this.isCreative = ItemSatchel.isCreative((ItemStack)stack);
        this.isVoid = ItemSatchel.isVoid(stack);
        this.storageIndex = ItemSatchel.getStorageIndex(stack);
        this.rowSize = MathHelper.clamp((int)this.storageIndex, (int)9, (int)14);
        int rows = MathHelper.clamp((int)this.storageIndex, (int)2, (int)9);
        int slots = this.rowSize * rows;
        int yOffset = 17;
        this.bindPlayerInventory(inventory);
        switch (this.storageIndex) {
            case 0: {
                if (this.isVoid) {
                    this.func_75146_a(new SlotSatchelVoid((IInventory)this.containerWrapper, 0, 80, 26));
                } else {
                    this.func_75146_a(new SlotSatchelCreative(this, (IInventory)this.containerWrapper, 0, 80, 26));
                }
                this.rowSize = 1;
                break;
            }
            case 1: {
                yOffset += 9;
                for (int i = 0; i < 9; ++i) {
                    this.func_75146_a((Slot)new SlotValidated((ISlotValidator)this, (IInventory)this.containerWrapper, i, 8 + i % this.rowSize * 18, yOffset + i / this.rowSize * 18));
                }
                break;
            }
            default: {
                for (int i = 0; i < slots; ++i) {
                    this.func_75146_a((Slot)new SlotValidated((ISlotValidator)this, (IInventory)this.containerWrapper, i, 8 + i % this.rowSize * 18, yOffset + i / this.rowSize * 18));
                }
            }
        }
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        int xOffset = this.getPlayerInventoryHorizontalOffset();
        int yOffset = this.getPlayerInventoryVerticalOffset();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (i == inventoryPlayer.field_70461_c) {
                this.func_75146_a((Slot)new SlotLocked((IInventory)inventoryPlayer, i, xOffset + i * 18, yOffset + 58));
                continue;
            }
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, xOffset + i * 18, yOffset + 58));
        }
    }

    public String getInventoryName() {
        return this.containerWrapper.func_145818_k_() ? this.containerWrapper.func_70005_c_() : StringHelper.localize((String)NAME);
    }

    protected int getPlayerInventoryVerticalOffset() {
        return 30 + 18 * MathHelper.clamp((int)this.storageIndex, (int)2, (int)9);
    }

    protected int getPlayerInventoryHorizontalOffset() {
        return 8 + 9 * (this.rowSize - 9);
    }

    public boolean setAccess(ISecurable.AccessMode access) {
        if (SecurityHelper.setAccess((ItemStack)this.getContainerStack(), (ISecurable.AccessMode)access)) {
            this.onSlotChanged();
            if (CoreUtils.isClient()) {
                PacketCore.sendSecurityPacketToServer((ISecurable)this);
            }
            return true;
        }
        return false;
    }

    public ISecurable.AccessMode getAccess() {
        return SecurityHelper.getAccess((ItemStack)this.getContainerStack());
    }

    public String getOwnerName() {
        return SecurityHelper.getOwnerName((ItemStack)this.getContainerStack());
    }

    public GameProfile getOwner() {
        return SecurityHelper.getOwner((ItemStack)this.getContainerStack());
    }

    public boolean canPlayerAccess(EntityPlayer player) {
        throw new UnsupportedOperationException();
    }

    public boolean setOwnerName(String name) {
        throw new UnsupportedOperationException();
    }

    public boolean setOwner(GameProfile name) {
        throw new UnsupportedOperationException();
    }

    public boolean isItemValid(ItemStack stack) {
        return this.containerWrapper.func_94041_b(0, stack);
    }

    @ContainerSectionCallback
    @Optional.Method(modid="inventorytweaks")
    public Map<ContainerSection, List<Slot>> getContainerSections() {
        Object2ObjectOpenHashMap slotRefs = new Object2ObjectOpenHashMap();
        slotRefs.put(ContainerSection.INVENTORY, this.field_75151_b.subList(0, 36));
        slotRefs.put(ContainerSection.INVENTORY_NOT_HOTBAR, this.field_75151_b.subList(0, 27));
        slotRefs.put(ContainerSection.INVENTORY_HOTBAR, this.field_75151_b.subList(27, 36));
        slotRefs.put(ContainerSection.CHEST, this.field_75151_b.subList(36, this.field_75151_b.size()));
        return slotRefs;
    }

    @ChestContainer.RowSizeCallback
    @Optional.Method(modid="inventorytweaks")
    public int getRowSize() {
        return this.rowSize;
    }
}

