/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.util.ItemWrapper;
import cofh.core.util.helpers.ItemHelper;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ExtruderManager {
    private static Map<ItemWrapper, ExtruderRecipe> recipeMapIgneous = new Object2ObjectOpenHashMap();
    private static Map<ItemWrapper, ExtruderRecipe> recipeMapSedimentary = new Object2ObjectOpenHashMap();
    private static List<ItemStack> outputListIgneous = new ArrayList<ItemStack>();
    private static List<ItemStack> outputListSedimentary = new ArrayList<ItemStack>();
    public static final int DEFAULT_ENERGY = 800;

    public static ExtruderRecipe getRecipe(ItemStack input, boolean sedimentary) {
        if (input.func_190926_b()) {
            return null;
        }
        return sedimentary ? recipeMapSedimentary.get(new ItemWrapper(input)) : recipeMapIgneous.get(new ItemWrapper(input));
    }

    public static boolean recipeExists(ItemStack input, boolean sedimentary) {
        return ExtruderManager.getRecipe(input, sedimentary) != null;
    }

    public static ItemStack getOutput(int index, boolean sedimentary) {
        return sedimentary ? outputListSedimentary.get(index) : outputListIgneous.get(index);
    }

    public static int getOutputListSize(boolean sedimentary) {
        return sedimentary ? outputListSedimentary.size() : outputListIgneous.size();
    }

    public static int getIndex(ItemStack output, boolean sedimentary) {
        if (sedimentary) {
            for (int i = 0; i < outputListSedimentary.size(); ++i) {
                if (!ItemHelper.itemsIdentical((ItemStack)output, (ItemStack)outputListSedimentary.get(i))) continue;
                return i;
            }
        } else {
            for (int i = 0; i < outputListIgneous.size(); ++i) {
                if (!ItemHelper.itemsIdentical((ItemStack)output, (ItemStack)outputListIgneous.get(i))) continue;
                return i;
            }
        }
        return 0;
    }

    public static ExtruderRecipe[] getRecipeList(boolean sedimentary) {
        if (sedimentary) {
            return recipeMapSedimentary.values().toArray(new ExtruderRecipe[recipeMapSedimentary.size()]);
        }
        return recipeMapIgneous.values().toArray(new ExtruderRecipe[recipeMapIgneous.size()]);
    }

    public static void initialize() {
        ExtruderManager.addRecipeIgneous(400, new ItemStack(Blocks.field_150347_e), new FluidStack(FluidRegistry.LAVA, 0), new FluidStack(FluidRegistry.WATER, 0));
        ExtruderManager.addRecipeIgneous(800, new ItemStack(Blocks.field_150348_b), new FluidStack(FluidRegistry.LAVA, 0), new FluidStack(FluidRegistry.WATER, 1000));
        ExtruderManager.addRecipeIgneous(1600, new ItemStack(Blocks.field_150343_Z), new FluidStack(FluidRegistry.LAVA, 1000), new FluidStack(FluidRegistry.WATER, 1000));
        ExtruderManager.addRecipeIgneous(800, new ItemStack(Blocks.field_150348_b, 1, 1), new FluidStack(FluidRegistry.LAVA, 0), new FluidStack(FluidRegistry.WATER, 1000));
        ExtruderManager.addRecipeIgneous(800, new ItemStack(Blocks.field_150348_b, 1, 3), new FluidStack(FluidRegistry.LAVA, 0), new FluidStack(FluidRegistry.WATER, 1000));
        ExtruderManager.addRecipeIgneous(800, new ItemStack(Blocks.field_150348_b, 1, 5), new FluidStack(FluidRegistry.LAVA, 0), new FluidStack(FluidRegistry.WATER, 1000));
        ExtruderManager.addRecipeSedimentary(2400, new ItemStack(Blocks.field_150351_n, 1), new FluidStack(FluidRegistry.LAVA, 0), new FluidStack(FluidRegistry.WATER, 1500));
        ExtruderManager.addRecipeSedimentary(3200, new ItemStack((Block)Blocks.field_150354_m, 1), new FluidStack(FluidRegistry.LAVA, 0), new FluidStack(FluidRegistry.WATER, 1500));
        ExtruderManager.addRecipeSedimentary(3200, new ItemStack((Block)Blocks.field_150354_m, 1, 1), new FluidStack(FluidRegistry.LAVA, 0), new FluidStack(FluidRegistry.WATER, 1500));
        ExtruderManager.addRecipeSedimentary(6400, new ItemStack(Blocks.field_150322_A, 1), new FluidStack(FluidRegistry.LAVA, 0), new FluidStack(FluidRegistry.WATER, 2000));
        ExtruderManager.addRecipeSedimentary(6400, new ItemStack(Blocks.field_180395_cM, 1), new FluidStack(FluidRegistry.LAVA, 0), new FluidStack(FluidRegistry.WATER, 2000));
        ExtruderManager.loadRecipes();
    }

    public static void loadRecipes() {
    }

    public static void refresh() {
        ItemWrapper output;
        ExtruderRecipe tempRecipe;
        Object2ObjectOpenHashMap tempMapIgneous = new Object2ObjectOpenHashMap(recipeMapIgneous.size());
        Object2ObjectOpenHashMap tempMapSedimentary = new Object2ObjectOpenHashMap(recipeMapSedimentary.size());
        for (Map.Entry<ItemWrapper, ExtruderRecipe> entry : recipeMapIgneous.entrySet()) {
            tempRecipe = entry.getValue();
            output = new ItemWrapper(tempRecipe.output);
            tempMapIgneous.put(output, tempRecipe);
        }
        for (Map.Entry<ItemWrapper, ExtruderRecipe> entry : recipeMapSedimentary.entrySet()) {
            tempRecipe = entry.getValue();
            output = new ItemWrapper(tempRecipe.output);
            tempMapSedimentary.put(output, tempRecipe);
        }
        recipeMapIgneous.clear();
        recipeMapSedimentary.clear();
        recipeMapIgneous = tempMapIgneous;
        recipeMapSedimentary = tempMapSedimentary;
    }

    public static ExtruderRecipe addRecipeIgneous(int energy, ItemStack output, FluidStack inputHot, FluidStack inputCold) {
        if (output.func_190926_b() || inputHot == null || inputCold == null || energy <= 0 || ExtruderManager.recipeExists(output, false)) {
            return null;
        }
        ExtruderRecipe recipe = new ExtruderRecipe(output, inputHot, inputCold, energy);
        recipeMapIgneous.put(new ItemWrapper(output), recipe);
        outputListIgneous.add(output);
        return recipe;
    }

    public static ExtruderRecipe addRecipeSedimentary(int energy, ItemStack output, FluidStack inputHot, FluidStack inputCold) {
        if (output.func_190926_b() || inputHot == null || inputCold == null || energy <= 0 || ExtruderManager.recipeExists(output, true)) {
            return null;
        }
        ExtruderRecipe recipe = new ExtruderRecipe(output, inputHot, inputCold, energy);
        recipeMapSedimentary.put(new ItemWrapper(output), recipe);
        outputListSedimentary.add(output);
        return recipe;
    }

    public static class ExtruderRecipe {
        final ItemStack output;
        final FluidStack inputHot;
        final FluidStack inputCold;
        final int energy;

        ExtruderRecipe(ItemStack output, FluidStack inputHot, FluidStack inputCold, int energy) {
            this.inputHot = inputHot;
            this.inputCold = inputCold;
            this.output = output;
            this.energy = energy;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public FluidStack getInputHot() {
            return this.inputHot;
        }

        public FluidStack getInputCold() {
            return this.inputCold;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

