/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionTri;
import buildcraft.lib.expression.node.value.NodeConstantLong;
import java.util.Objects;

public class NodeFuncLongLongToLong
extends NodeFuncBase
implements INodeFunc.INodeFuncLong {
    public final IFuncLongLongToLong function;
    private final StringFunctionTri stringFunction;

    public NodeFuncLongLongToLong(String name, IFuncLongLongToLong function) {
        this(function, (String a, String b) -> "[ long, long -> long ] " + name + "(" + a + ", " + b + ")");
    }

    public NodeFuncLongLongToLong(IFuncLongLongToLong function, StringFunctionTri stringFunction) {
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}", "{B}");
    }

    @Override
    public NodeFuncLongLongToLong setNeverInline() {
        super.setNeverInline();
        return this;
    }

    @Override
    public IExpressionNode.INodeLong getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeLong b = stack.popLong();
        IExpressionNode.INodeLong a = stack.popLong();
        return this.create(a, b);
    }

    public FuncLongLongToLong create(IExpressionNode.INodeLong argA, IExpressionNode.INodeLong argB) {
        return new FuncLongLongToLong(argA, argB);
    }

    @FunctionalInterface
    public static interface IFuncLongLongToLong {
        public long apply(long var1, long var3);
    }

    public class FuncLongLongToLong
    implements IExpressionNode.INodeLong,
    IDependantNode,
    NodeFuncBase.IFunctionNode {
        public final IExpressionNode.INodeLong argA;
        public final IExpressionNode.INodeLong argB;

        public FuncLongLongToLong(IExpressionNode.INodeLong argA, IExpressionNode.INodeLong argB) {
            this.argA = argA;
            this.argB = argB;
        }

        @Override
        public long evaluate() {
            return NodeFuncLongLongToLong.this.function.apply(this.argA.evaluate(), this.argB.evaluate());
        }

        @Override
        public IExpressionNode.INodeLong inline() {
            if (!NodeFuncLongLongToLong.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new FuncLongLongToLong((IExpressionNode.INodeLong)a, (IExpressionNode.INodeLong)b), (a, b) -> new FuncLongLongToLong((IExpressionNode.INodeLong)a, (IExpressionNode.INodeLong)b));
            }
            return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new FuncLongLongToLong((IExpressionNode.INodeLong)a, (IExpressionNode.INodeLong)b), (a, b) -> NodeConstantLong.of(NodeFuncLongLongToLong.this.function.apply(a.evaluate(), b.evaluate())));
        }

        @Override
        public void visitDependants(IDependancyVisitor visitor) {
            if (!NodeFuncLongLongToLong.this.canInline) {
                if (NodeFuncLongLongToLong.this.function instanceof IDependantNode) {
                    visitor.dependOn((IDependantNode)((Object)NodeFuncLongLongToLong.this.function));
                } else {
                    visitor.dependOnExplictly(this);
                }
            }
            visitor.dependOn(this.argA, this.argB);
        }

        public String toString() {
            return NodeFuncLongLongToLong.this.stringFunction.apply(this.argA.toString(), this.argB.toString());
        }

        @Override
        public NodeFuncBase getFunction() {
            return NodeFuncLongLongToLong.this;
        }

        public int hashCode() {
            return Objects.hash(this.argA, this.argB);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FuncLongLongToLong other = (FuncLongLongToLong)obj;
            return Objects.equals(this.argA, other.argA) && Objects.equals(this.argB, other.argB);
        }
    }
}

