/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.json;

import buildcraft.lib.client.model.ResourceLoaderContext;
import buildcraft.lib.expression.DefaultContexts;
import buildcraft.lib.gui.json.ElementType;
import buildcraft.lib.gui.json.ElementTypeButton;
import buildcraft.lib.gui.json.ElementTypeContainer;
import buildcraft.lib.gui.json.ElementTypeDrawnStack;
import buildcraft.lib.gui.json.ElementTypeHelp;
import buildcraft.lib.gui.json.ElementTypeLedger;
import buildcraft.lib.gui.json.ElementTypeSlot;
import buildcraft.lib.gui.json.ElementTypeSprite;
import buildcraft.lib.gui.json.ElementTypeStatementParam;
import buildcraft.lib.gui.json.ElementTypeStatementSlot;
import buildcraft.lib.gui.json.ElementTypeStatementSource;
import buildcraft.lib.gui.json.ElementTypeText;
import buildcraft.lib.gui.json.ElementTypeToolTip;
import buildcraft.lib.gui.json.JsonGuiInfo;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class JsonGuiTypeRegistry {
    public static final Map<String, ElementType> TYPES = new HashMap<String, ElementType>();

    public static void registerType(ElementType type) {
        TYPES.put(type.name, type);
    }

    public static void main(String[] args) throws IOException {
        JsonObject obj;
        String loc = "/assets/buildcraftbuilders/gui/filler.json";
        InputStream is = JsonGuiTypeRegistry.class.getResourceAsStream(loc);
        try (InputStreamReader isr = new InputStreamReader(is);){
            obj = (JsonObject)new Gson().fromJson((Reader)isr, JsonObject.class);
        }
        JsonGuiInfo info = new JsonGuiInfo(obj, DefaultContexts.createWithAll(), new ResourceLoaderContext());
        info.printOut(System.out::println);
    }

    static {
        JsonGuiTypeRegistry.registerType(ElementTypeText.INSTANCE);
        JsonGuiTypeRegistry.registerType(ElementTypeHelp.INSTANCE);
        JsonGuiTypeRegistry.registerType(ElementTypeSlot.INSTANCE);
        JsonGuiTypeRegistry.registerType(ElementTypeSprite.INSTANCE);
        JsonGuiTypeRegistry.registerType(ElementTypeButton.INSTANCE);
        JsonGuiTypeRegistry.registerType(ElementTypeLedger.INSTANCE);
        JsonGuiTypeRegistry.registerType(ElementTypeToolTip.INSTANCE);
        JsonGuiTypeRegistry.registerType(ElementTypeContainer.INSTANCE);
        JsonGuiTypeRegistry.registerType(ElementTypeDrawnStack.INSTANCE);
        JsonGuiTypeRegistry.registerType(ElementTypeStatementSlot.INSTANCE);
        JsonGuiTypeRegistry.registerType(ElementTypeStatementParam.INSTANCE);
        JsonGuiTypeRegistry.registerType(ElementTypeStatementSource.INSTANCE);
    }
}

