/*
 * Decompiled with CFR 0.152.
 */
package com.rejahtavi.rfp2;

import com.rejahtavi.rfp2.IProxy;
import com.rejahtavi.rfp2.RFP2Config;
import com.rejahtavi.rfp2.RFP2Keybind;
import com.rejahtavi.rfp2.RFP2State;
import com.rejahtavi.rfp2.compat.RFP2CompatApi;
import com.rejahtavi.rfp2.compat.handlers.RFP2CompatHandler;
import com.rejahtavi.rfp2.compat.handlers.RFP2CompatHandlerBaubles;
import com.rejahtavi.rfp2.compat.handlers.RFP2CompatHandlerCosarmor;
import com.rejahtavi.rfp2.compat.handlers.RFP2CompatHandlerIdo;
import com.rejahtavi.rfp2.compat.handlers.RFP2CompatHandlerMorph;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="rfp2", name="Real First Person 2", version="1.12.2-1.3.2", dependencies="after:cosmeticarmorreworked;after:ido;after:morph;", clientSideOnly=true, acceptedMinecraftVersions="1.12.2", acceptableRemoteVersions="*")
public class RFP2 {
    public static final String[] CONFLICT_MODIDS = new String[]{"obfuscate", "moreplayermodels", "playerformlittlemaid"};
    public static final String MODID = "rfp2";
    public static final String MODNAME = "Real First Person 2";
    public static final String MODVER = "1.12.2-1.3.2";
    public static final String MODDEPS = "after:cosmeticarmorreworked;after:ido;after:morph;";
    public static ArrayList<RFP2CompatHandler> compatHandlers = new ArrayList();
    public static final int DUMMY_MIN_RESPAWN_INTERVAL = 40;
    public static final int DUMMY_UPDATE_TIMEOUT = 20;
    public static final int DUMMY_MAX_SEPARATION = 5;
    public static final int MAX_SUSPEND_TIMER = 60;
    public static final int MIN_IGNORED_ERROR_LOG_INTERVAL = 60;
    public static final int MIN_ACTIVATION_CHECK_INTERVAL = 4;
    public static final long MIN_TICKS_BETWEEN_ERROR_LOGS = 1200L;
    public static final int MIN_REAL_ARMS_CHECK_INTERVAL = 1;
    @Mod.Instance(value="rfp2")
    public static RFP2 INSTANCE;
    @SidedProxy(clientSide="com.rejahtavi.rfp2.ClientProxy", serverSide="com.rejahtavi.rfp2.ServerProxy")
    public static IProxy PROXY;
    public static RFP2Keybind keybindArmsToggle;
    public static RFP2Keybind keybindModToggle;
    public static RFP2Keybind keybindHeadRotationToggle;
    public static RFP2Config config;
    public static RFP2State state;
    public static Logger logger;
    public static long lastLoggedTimestamp;
    public static long ignoredErrorCount;
    public static RFP2CompatApi api;
    public static final Level LOGGING_LEVEL_DEBUG;
    public static final Level LOGGING_LEVEL_LOW;
    public static final Level LOGGING_LEVEL_MED;
    public static final Level LOGGING_LEVEL_HIGH;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PROXY.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PROXY.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        String logMessage = "";
        compatHandlers = new ArrayList();
        if (Loader.isModLoaded((String)"baubles")) {
            compatHandlers.add(new RFP2CompatHandlerBaubles());
            logMessage = logMessage + "baubles, ";
        }
        if (Loader.isModLoaded((String)"cosmeticarmorreworked")) {
            compatHandlers.add(new RFP2CompatHandlerCosarmor());
            logMessage = logMessage + "cosmeticarmorreworked, ";
        }
        if (Loader.isModLoaded((String)"ido")) {
            compatHandlers.add(new RFP2CompatHandlerIdo());
            logMessage = logMessage + "ido, ";
        }
        if (Loader.isModLoaded((String)"morph")) {
            compatHandlers.add(new RFP2CompatHandlerMorph());
            logMessage = logMessage + "morph, ";
        }
        if (logMessage.length() > 0) {
            logMessage = "Compatibility handler(s) loaded for: " + logMessage.substring(0, logMessage.length() - 2) + ".";
            logger.log(LOGGING_LEVEL_MED, logMessage);
        }
        PROXY.postInit(event);
    }

    public static void logToChat(String message) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            TextComponentString textToSend = new TextComponentString(message);
            player.func_145747_a((ITextComponent)textToSend);
        }
    }

    public static void logToChatByPlayer(String message, EntityPlayer player) {
        if (player != null) {
            TextComponentString textToSend = new TextComponentString(message);
            player.func_145747_a((ITextComponent)textToSend);
        }
    }

    public static void errorDisableMod(String sourceMethod, Exception e) {
        if (RFP2Config.compatibility.disableRenderErrorCatching) {
            long epoch = System.currentTimeMillis() / 1000L;
            if (epoch >= lastLoggedTimestamp + 60L) {
                logger.log(LOGGING_LEVEL_MED, ": " + sourceMethod + " **IGNORING** exception:" + e.getMessage());
                if (ignoredErrorCount > 0L) {
                    logger.log(LOGGING_LEVEL_MED, ": (" + ignoredErrorCount + " errors ignored in last " + 60 + "s.)");
                }
                ignoredErrorCount = 0L;
                lastLoggedTimestamp = epoch;
            } else {
                ++ignoredErrorCount;
            }
        } else {
            RFP2.state.enableMod = false;
            logger.log(LOGGING_LEVEL_HIGH, ": first person rendering deactivated.");
            logger.log(LOGGING_LEVEL_HIGH, ": " + sourceMethod + " encountered an exception:" + e.getMessage());
            e.printStackTrace();
            RFP2.logToChat("Real First Person 2 mod " + TextFormatting.RED + " disabled");
            RFP2.logToChat(sourceMethod + " encountered an exception:");
            RFP2.logToChat(TextFormatting.RED + e.getMessage());
            RFP2.logToChat(TextFormatting.DARK_RED + e.getStackTrace().toString());
            RFP2.logToChat(TextFormatting.GOLD + "Please check your minecraft log file for more details.");
        }
    }

    static {
        keybindArmsToggle = new RFP2Keybind("key.arms.desc", 39, "key.rfp2.category");
        keybindModToggle = new RFP2Keybind("key.mod.desc", 40, "key.rfp2.category");
        keybindHeadRotationToggle = new RFP2Keybind("key.head.desc", 35, "key.rfp2.category");
        lastLoggedTimestamp = 0L;
        ignoredErrorCount = 0L;
        api = new RFP2CompatApi();
        LOGGING_LEVEL_DEBUG = Level.DEBUG;
        LOGGING_LEVEL_LOW = Level.INFO;
        LOGGING_LEVEL_MED = Level.WARN;
        LOGGING_LEVEL_HIGH = Level.FATAL;
    }
}

