/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.generation.BOPGeneratorBase;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.block.BlockBOPLilypad;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import java.util.Random;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GeneratorMixedLily
extends BOPGeneratorBase {
    protected static IBlockState[] lilies = new IBlockState[]{BOPBlocks.waterlily.func_176223_P().func_177226_a((IProperty)BlockBOPLilypad.VARIANT, (Comparable)((Object)BlockBOPLilypad.LilypadType.TINY)), BOPBlocks.waterlily.func_176223_P().func_177226_a((IProperty)BlockBOPLilypad.VARIANT, (Comparable)((Object)BlockBOPLilypad.LilypadType.SMALL)), BOPBlocks.waterlily.func_176223_P().func_177226_a((IProperty)BlockBOPLilypad.VARIANT, (Comparable)((Object)BlockBOPLilypad.LilypadType.MEDIUM)), Blocks.field_150392_bi.func_176223_P()};
    protected static IBlockPosQuery replace = new BlockQuery.BlockQueryMaterial(Material.field_151579_a);
    protected int generationAttempts;

    public GeneratorMixedLily(float amountPerChunk, int generationAttempts) {
        super(amountPerChunk);
        this.generationAttempts = generationAttempts;
        for (IBlockState lily : lilies) {
            if (lily.func_177230_c() instanceof BlockLilyPad) continue;
            throw new RuntimeException("GeneratorMixedLily liles must all be instances of BlockLilyPad");
        }
    }

    @Override
    public BlockPos getScatterY(World world, Random random, int x, int z) {
        return GeneratorUtils.ScatterYMethod.AT_SURFACE.getBlockPos(world, random, x, z);
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        for (int i = 0; i < this.generationAttempts; ++i) {
            BlockPos genPos = pos.func_177982_a(random.nextInt(8) - random.nextInt(8), random.nextInt(4) - random.nextInt(4), random.nextInt(8) - random.nextInt(8));
            IBlockState lily = lilies[random.nextInt(lilies.length)];
            if (!replace.matches(world, genPos) || !((BlockLilyPad)lily.func_177230_c()).func_180671_f(world, genPos, lily)) continue;
            world.func_180501_a(genPos, lily, 2);
        }
        return true;
    }

    @Override
    public void configure(IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.generationAttempts = conf.getInt("generationAttempts", this.generationAttempts);
    }

    public static class Builder
    extends BOPGeneratorBase.InnerBuilder<Builder, GeneratorMixedLily>
    implements IGenerator.IGeneratorBuilder<GeneratorMixedLily> {
        protected int generationAttempts;

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.generationAttempts = 64;
        }

        public Builder generationAttempts(int a) {
            this.generationAttempts = a;
            return (Builder)this.self();
        }

        @Override
        public GeneratorMixedLily create() {
            return new GeneratorMixedLily(this.amountPerChunk, this.generationAttempts);
        }
    }
}

