/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.utils.items;

import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.item.GCRarity;
import micdoodle8.mods.galacticraft.core.TransformerHooks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.MorePlanetsMod;
import stevekung.mods.moreplanets.init.MPItems;
import stevekung.mods.moreplanets.planets.diona.entity.projectile.EntityAntiGravityArrow;
import stevekung.mods.moreplanets.planets.diona.entity.projectile.EntityInfectedPurloniteArrow;
import stevekung.mods.moreplanets.planets.nibiru.entity.projectile.EntityInfectedArrow;
import stevekung.mods.moreplanets.utils.BlocksItemsRegistry;
import stevekung.mods.moreplanets.utils.client.renderer.IItemModelRender;
import stevekung.mods.moreplanets.utils.itemblocks.IItemRarity;
import stevekung.mods.moreplanets.utils.items.EnumSortCategoryItem;
import stevekung.mods.moreplanets.utils.items.ISortableItem;
import stevekung.mods.stevekunglib.utils.ColorUtils;
import stevekung.mods.stevekunglib.utils.LangUtils;
import stevekung.mods.stevekunglib.utils.client.ClientUtils;

public class ItemArrowMP
extends ItemArrow
implements ISortableItem,
IItemModelRender,
IItemRarity,
GCRarity {
    private final ArrowType type;
    private ColorUtils.RGB rgb;
    private final String name;

    public ItemArrowMP(String name, ArrowType type) {
        this.type = type;
        this.name = name;
        this.func_77655_b(name);
    }

    public CreativeTabs func_77640_w() {
        return MorePlanetsMod.ITEM_TAB;
    }

    @Override
    public EnumSortCategoryItem getItemCategory() {
        return EnumSortCategoryItem.ARROW;
    }

    public EntityArrow func_185052_a(World world, ItemStack itemStack, EntityLivingBase shooter) {
        switch (this.type) {
            case INFECTED_PURLONITE: {
                return new EntityInfectedPurloniteArrow(world, shooter);
            }
            case INFECTED: {
                return new EntityInfectedArrow(world, shooter);
            }
            case ANTI_GRAVITY: {
                return new EntityAntiGravityArrow(world, shooter);
            }
        }
        return super.func_185052_a(world, itemStack, shooter);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (this.type == ArrowType.INFECTED) {
            if (ClientUtils.isShiftKeyDown()) {
                list.addAll(BlocksItemsRegistry.getDescription(this.func_77658_a() + ".description"));
            } else {
                list.add(LangUtils.translate((String)"desc.shift_info.name"));
            }
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.func_92059_d().func_77973_b() == MPItems.ANTI_GRAVITY_ARROW) {
            entityItem.field_70181_x += TransformerHooks.getItemGravity((EntityItem)entityItem);
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ColorUtils.RGB getRarity() {
        return this.rgb != null ? this.rgb : null;
    }

    public String func_77653_i(ItemStack itemStack) {
        return this instanceof IItemRarity && this.getRarity() != null ? this.getRarity().toColoredFont() + super.func_77653_i(itemStack) : super.func_77653_i(itemStack);
    }

    public ItemArrowMP setRarityRGB(ColorUtils.RGB rgb) {
        this.rgb = rgb;
        return this;
    }

    public static enum ArrowType {
        INFECTED_PURLONITE,
        INFECTED,
        ANTI_GRAVITY;

    }
}

