/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedbackpacks.blocks;

import com.google.common.base.Predicate;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.poopycoders.improvedbackpacks.ImprovedBackpacks;
import ru.poopycoders.improvedbackpacks.items.ItemBackpack;
import ru.poopycoders.improvedbackpacks.tiles.TileEntityBackpack;
import ru.poopycoders.improvedbackpacks.utils.ColorUtils;

public class BlockBackpack
extends BlockContainer
implements ITileEntityProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockBackpack() {
        super(Material.field_151576_e);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149752_b(15.0f);
        this.field_149783_u = true;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return state.func_177230_c() != this;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.func_180646_a(state, source, pos);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.875, 0.875);
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return this.func_180646_a(state, (IBlockAccess)worldIn, pos).func_186670_a(pos);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBackpack();
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityBackpack();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityBackpack tile = (TileEntityBackpack)world.func_175625_s(pos);
        if (tile != null) {
            tile.setTier(ItemBackpack.getTier(stack));
            tile.setUuid(ItemBackpack.getUUID(stack));
            tile.loadItemsFromBackpack(stack);
            tile.setColor(ItemBackpack.getBackpackDyeColor(stack));
            if (stack.func_82837_s()) {
                tile.setCustomName(stack.func_82833_r());
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            world.func_184148_a(player, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187728_s, SoundCategory.BLOCKS, 1.0f, 1.5f);
            return true;
        }
        TileEntityBackpack te = (TileEntityBackpack)world.func_175625_s(pos);
        if (te != null) {
            EnumDyeColor heldColor;
            ItemStack held = player.func_184586_b(hand);
            if (!held.func_190926_b() && (heldColor = ColorUtils.getColorByOreDictionary(held)) != null) {
                if (!player.func_184812_l_()) {
                    held.func_190920_e(held.func_190916_E() - 1);
                }
                te.setColor(heldColor);
                te.func_70296_d();
                world.func_184138_a(pos, state, state, 3);
                return true;
            }
            player.openGui((Object)ImprovedBackpacks.INSTANCE, 2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack backpack = ItemStack.field_190927_a;
        TileEntityBackpack tile = (TileEntityBackpack)world.func_175625_s(pos);
        if (tile != null) {
            if (player.field_71075_bZ.field_75098_d && GuiScreen.func_146271_m() && state.func_177230_c().hasTileEntity(state)) {
                backpack = tile.exportToItemStack();
                ItemBackpack.setBackpackUUID(backpack, UUID.randomUUID());
            } else {
                backpack = tile.getPickBlock();
            }
        }
        return backpack;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntityBackpack tile = (TileEntityBackpack)world.func_175625_s(pos);
        if (tile != null) {
            tile.setDestroyedByCreativePlayer(player.field_71075_bZ.field_75098_d);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        ItemStack stack;
        TileEntityBackpack tile = (TileEntityBackpack)world.func_175625_s(pos);
        if (tile != null && tile.shouldDrop() && !(stack = tile.exportToItemStack()).func_190926_b()) {
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)world.func_175625_s(pos)));
    }
}

