/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedbackpacks.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import ru.poopycoders.improvedbackpacks.command.InvalidDyeColorException;
import ru.poopycoders.improvedbackpacks.init.ModConfig;
import ru.poopycoders.improvedbackpacks.init.ModItems;
import ru.poopycoders.improvedbackpacks.items.ItemBackpack;

public class CommandGiveBackpack
extends CommandBase {
    private List<String> aliases = new ArrayList<String>();

    public CommandGiveBackpack() {
        this.aliases.add("giveimprovedbackpack");
        this.aliases.add("ibackpack");
    }

    public String func_71517_b() {
        return "givebackpack";
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/givebackpack <tier> [color]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Usage: /givebackpack <tier> [color]"));
        } else if (sender instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)sender;
            int tier = CommandGiveBackpack.func_175764_a((String)args[0], (int)0, (int)ModConfig.maxBackpackTier);
            EnumDyeColor color = null;
            if (args.length >= 2) {
                color = CommandGiveBackpack.parseEnumDyeColor(args[1]);
            }
            ItemStack stack = new ItemStack((Item)ModItems.BACKPACK);
            ItemBackpack.setTier(stack, tier);
            ItemBackpack.setBackpackColor(stack, color);
            player.field_71071_by.func_70441_a(stack);
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("This command is not supporting console input."));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 2) {
            return Arrays.stream(EnumDyeColor.values()).map(EnumDyeColor::func_176762_d).collect(Collectors.toList());
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    public static EnumDyeColor parseEnumDyeColor(String input) throws InvalidDyeColorException {
        EnumDyeColor color = null;
        for (EnumDyeColor dyeColor : EnumDyeColor.values()) {
            if (!input.equalsIgnoreCase(dyeColor.func_176762_d())) continue;
            color = dyeColor;
            break;
        }
        if (color == null) {
            throw new InvalidDyeColorException("Invalid color '" + input + "'", new Object[0]);
        }
        return color;
    }
}

