/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedbackpacks.utils;

import java.util.HashMap;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ColorUtils {
    public static HashMap<String, EnumDyeColor> oreDictDyeColors = new HashMap();
    public static HashMap<EnumDyeColor, String> dyeColorsOreDict = new HashMap();

    private static void registerColor(String od, EnumDyeColor color) {
        oreDictDyeColors.put(od, color);
        dyeColorsOreDict.put(color, od);
    }

    public static EnumDyeColor getColorByOreDictionary(ItemStack is) {
        EnumDyeColor dyeColor = null;
        for (int oreID : OreDictionary.getOreIDs((ItemStack)is)) {
            String oreName = OreDictionary.getOreName((int)oreID);
            EnumDyeColor color = oreDictDyeColors.get(oreName);
            if (color == null) continue;
            if (dyeColor == null) {
                dyeColor = color;
                continue;
            }
            return null;
        }
        return dyeColor;
    }

    public static int interpolateColor(int a, int b, float percent) {
        if (percent <= 0.0f) {
            return a;
        }
        if (percent >= 1.0f) {
            return b;
        }
        int ra = a >> 16 & 0xFF;
        int ga = a >> 8 & 0xFF;
        int ba = a & 0xFF;
        int aa = a >> 24;
        int rb = b >> 16 & 0xFF;
        int gb = b >> 8 & 0xFF;
        int bb = b & 0xFF;
        int ab = b >> 24;
        float p1 = 1.0f - percent;
        int rc = (int)(p1 * (float)ra + percent * (float)rb);
        int gc = (int)(p1 * (float)ga + percent * (float)gb);
        int bc = (int)(p1 * (float)ba + percent * (float)bb);
        int ac = (int)(p1 * (float)aa + percent * (float)ab);
        return (ac << 24) + (rc << 16) + (gc << 8) + bc;
    }

    static {
        ColorUtils.registerColor("dyeBlack", EnumDyeColor.BLACK);
        ColorUtils.registerColor("dyeRed", EnumDyeColor.RED);
        ColorUtils.registerColor("dyeGreen", EnumDyeColor.GREEN);
        ColorUtils.registerColor("dyeBrown", EnumDyeColor.BROWN);
        ColorUtils.registerColor("dyeBlue", EnumDyeColor.BLUE);
        ColorUtils.registerColor("dyePurple", EnumDyeColor.PURPLE);
        ColorUtils.registerColor("dyeCyan", EnumDyeColor.CYAN);
        ColorUtils.registerColor("dyeLightGray", EnumDyeColor.SILVER);
        ColorUtils.registerColor("dyeGray", EnumDyeColor.GRAY);
        ColorUtils.registerColor("dyePink", EnumDyeColor.PINK);
        ColorUtils.registerColor("dyeLime", EnumDyeColor.LIME);
        ColorUtils.registerColor("dyeYellow", EnumDyeColor.YELLOW);
        ColorUtils.registerColor("dyeLightBlue", EnumDyeColor.LIGHT_BLUE);
        ColorUtils.registerColor("dyeMagenta", EnumDyeColor.MAGENTA);
        ColorUtils.registerColor("dyeOrange", EnumDyeColor.ORANGE);
        ColorUtils.registerColor("dyeWhite", EnumDyeColor.WHITE);
    }
}

