/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.noise;

public class NoiseUtils {
    private NoiseUtils() {
    }

    public static float simplexNoiseOffsetByPercent(float baseNoise, float percent) {
        float currNoise;
        float currCDFPercent = 0.0f;
        float basePercent = baseNoise == -1.0f ? 0.0f : NoiseUtils.noiseToCDF(baseNoise);
        for (currNoise = baseNoise; currCDFPercent < percent && currNoise < 1.0f; currNoise += 0.01f) {
            currCDFPercent = NoiseUtils.noiseToCDF(currNoise) - basePercent;
        }
        return currNoise - 0.01f;
    }

    public static float simplexNoiseNegativeOffsetByPercent(float baseNoise, float percent) {
        float currNoise;
        float basePercent;
        float currCDFPercent = 0.0f;
        float f = basePercent = baseNoise == 1.0f ? 1.0f : NoiseUtils.noiseToCDF(baseNoise);
        for (currNoise = baseNoise; currCDFPercent < percent && currNoise > -1.0f; currNoise -= 0.01f) {
            currCDFPercent = basePercent - NoiseUtils.noiseToCDF(currNoise);
        }
        return currNoise + 0.01f;
    }

    public static float noiseToCDF(float x) {
        return -0.435999f * x * x * x + 3.03E-4f * x * x + 0.916298f * x + 0.499721f;
    }
}

