/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver;

import com.yungnickyoung.minecraft.bettercaves.noise.NoiseCube;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseUtils;
import com.yungnickyoung.minecraft.bettercaves.world.carver.ICarver;

public class CarverNoiseRange {
    private float bottom;
    private float top;
    private float smoothBottomCutoff;
    private float smoothTopCutoff;
    private ICarver carver;
    private NoiseCube noiseCube;
    private static final float SMOOTH_PERCENT = 0.3f;

    public CarverNoiseRange(float bottom, float top, ICarver carver) {
        this.bottom = bottom;
        this.top = top;
        float smoothRangePercent = this.getPercentLength() * 0.3f;
        this.smoothBottomCutoff = NoiseUtils.simplexNoiseOffsetByPercent(bottom, smoothRangePercent);
        this.smoothTopCutoff = NoiseUtils.simplexNoiseNegativeOffsetByPercent(top, smoothRangePercent);
        this.carver = carver;
        this.noiseCube = null;
    }

    public boolean contains(float noiseValue) {
        return this.bottom <= noiseValue && noiseValue < this.top;
    }

    public float getSmoothAmp(float noiseValue) {
        if (this.bottom <= noiseValue && noiseValue <= this.smoothBottomCutoff) {
            return (noiseValue - this.bottom) / (this.smoothBottomCutoff - this.bottom);
        }
        if (this.smoothTopCutoff <= noiseValue && noiseValue < this.top) {
            return (noiseValue - this.top) / (this.smoothTopCutoff - this.top);
        }
        return 1.0f;
    }

    public float getPercentLength() {
        return (this.top == 1.0f ? 1.0f : NoiseUtils.noiseToCDF(this.top)) - (this.bottom == -1.0f ? 0.0f : NoiseUtils.noiseToCDF(this.bottom));
    }

    public ICarver getCarver() {
        return this.carver;
    }

    public NoiseCube getNoiseCube() {
        return this.noiseCube;
    }

    public void setNoiseCube(NoiseCube noiseCube) {
        this.noiseCube = noiseCube;
    }

    public String toString() {
        return String.format("[%2.2f, %2.2f] (%2.4f%%) -- smooth cutoffs: [%2.2f, %2.2f]", Float.valueOf(this.bottom), Float.valueOf(this.top), Float.valueOf(this.getPercentLength()), Float.valueOf(this.smoothBottomCutoff), Float.valueOf(this.smoothTopCutoff));
    }
}

