/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.core;

import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.config.FormattingConfig;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class HUDHandlerFluids
implements IWailaDataProvider {
    static final IWailaDataProvider INSTANCE = new HUDHandlerFluids();

    @Override
    @Nonnull
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return HUDHandlerFluids.getStackFromLiquid(accessor.getBlockState(), accessor);
    }

    @Override
    @Nonnull
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Fluid fluid = HUDHandlerFluids.getFluidFromBlock(accessor.getBlockState());
        if (fluid == null) {
            return currenttip;
        }
        String name = null;
        String displayName = String.format(FormattingConfig.fluidFormat, fluid.getLocalizedName(new FluidStack(fluid, 1000)));
        if (displayName != null && !displayName.endsWith("Unnamed")) {
            name = displayName;
        }
        if (name != null) {
            currenttip.add("\u00a7r" + name);
        }
        if (currenttip.isEmpty()) {
            currenttip.add("\u00a7r" + String.format(FormattingConfig.fluidFormat, "< Unnamed >"));
        } else if (ConfigHandler.instance().getConfig("general", "waila.cfg.metadata", true) && !Strings.isNullOrEmpty((String)FormattingConfig.metaFormat)) {
            currenttip.add(String.format(FormattingConfig.metaFormat, accessor.getBlock().getRegistryName().toString(), accessor.getMetadata()));
        }
        return currenttip;
    }

    @Override
    @Nonnull
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Fluid fluid = HUDHandlerFluids.getFluidFromBlock(accessor.getBlockState());
        if (fluid == null) {
            return currenttip;
        }
        String modName = ModIdentification.findModContainer(FluidRegistry.getDefaultFluidName((Fluid)fluid).split(":")[0]).getName();
        if (!Strings.isNullOrEmpty((String)FormattingConfig.modNameFormat) && !Strings.isNullOrEmpty((String)modName)) {
            currenttip.add(String.format(FormattingConfig.modNameFormat, modName));
        }
        return currenttip;
    }

    @Nonnull
    private static ItemStack getStackFromLiquid(IBlockState state, IWailaDataAccessor accessor) {
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((World)accessor.getWorld(), (BlockPos)accessor.getPosition(), (EnumFacing)accessor.getSide());
        if (fluidHandler == null) {
            return ItemStack.field_190927_a;
        }
        FluidStack stack = fluidHandler.drain(1000, false);
        if (stack == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack bucket = FluidUtil.getFilledBucket((FluidStack)stack);
        if (!bucket.func_190926_b()) {
            return bucket;
        }
        FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)new ItemStack(Items.field_151133_ar), (IFluidHandler)fluidHandler, (int)1, null, (boolean)false);
        return result.isSuccess() ? result.getResult() : ItemStack.field_190927_a;
    }

    @Nullable
    private static Fluid getFluidFromBlock(IBlockState state) {
        Fluid fluid = null;
        if (state.func_177230_c() instanceof BlockLiquid) {
            BlockStaticLiquid fluidBlock = BlockLiquid.func_176363_b((Material)state.func_185904_a());
            fluid = fluidBlock == Blocks.field_150355_j ? FluidRegistry.WATER : FluidRegistry.LAVA;
        } else if (state.func_177230_c() instanceof IFluidBlock) {
            fluid = ((IFluidBlock)state.func_177230_c()).getFluid();
        }
        return fluid;
    }
}

