/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.world.mapgen;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import mcjty.rftoolsdim.blocks.ModBlocks;
import mcjty.rftoolsdim.blocks.shards.AbstractDirectionalBlock;
import mcjty.rftoolsdim.dimensions.world.GenericChunkGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class MapGenRuinedCities {
    private final GenericChunkGenerator provider;
    private static Map<Character, IBlockState> blockMap = null;
    private static String[] LevelBase = new String[]{"BBBBBBBBBBBBBBB ", "BBBBBBBBBBBBBBB ", "BBBBBBBBBBBBBBB ", "BBBBBBBBBBBBBBB ", "BBBBBBBBBBBBBBB ", "BBBBBBBBBBBBBBB ", "BBBBBBBBBBBBBBB ", "BBBBBBBBBBBBBBB ", "BBBBBBBBBBBBBBB ", "BBBBBBBBBBBBBBB ", "BBBBBBBBBBBBBBB ", "BBBBBBBBBBBBBBB ", "BBBBBBBBBBBBBBB ", "BBBBBBBBBBBBBBB ", "BBBBBBBBBBBBBBB ", "                "};
    private static String[] Level1_3 = new String[]{"Pbbbbbb bbbbbbP ", "b     bPb     b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b   bb X bb   b ", "Pbbbx     xbbbP "};
    private static String[] Level4 = new String[]{"Pbbbbbb bbbbbbP ", "b     bPb     b ", "X             X ", "X             X ", "X             X ", "X             X ", "X             X ", "X             X ", "X             X ", "X             X ", "X             X ", "X             X ", "X             X ", "X             X ", "b   bbbbbbb   b ", "PbbbbbbbbbbbbbP "};
    private static String[] Level5_6 = new String[]{"Pbbbbbb bbbbbbP ", "b     bPb     b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "PbbbbbbbbbbbbbP "};
    private static String[] Level7 = new String[]{"Pbbbbbb bbbbbbP ", "b     bPb     b ", "X             X ", "X             X ", "X             X ", "X             X ", "X             X ", "X             X ", "X             X ", "X             X ", "X             X ", "X             X ", "b             b ", "b             b ", "b             b ", "PbbbbbbbbbbbbbP "};
    private static String[] Level8_9 = new String[]{"Pbbbbbb bbbbbbP ", "b     bPb     b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "b             b ", "PbbbbbbbbbbbbbP "};
    private static String[] Level10 = new String[]{"Pbbbbbb bbbbbbP ", "bBBBBBbPbBBBBBb ", "XBBBBBBBBBBBBBX ", "XBBBBBBBBBBBBBX ", "XBBBBBBBBBBBBBX ", "XBBBBBBBBBBBBBX ", "XBBBBBBBBBBBBBX ", "XBBBBBBBBBBBBBX ", "XBBBBBBBBBBBBBX ", "bBBBBBBBBBBBBBb ", "bBBBBBBBBBBBBBb ", "bBBBBBBBBBBBBBb ", "bBBBBBBBBBBBBBb ", "bBBBBBBBBBBBBBb ", "bBBBBBBBBBBBBBb ", "PbbbbbbbbbbbbbP "};
    private static String[] Level11 = new String[]{"Pbbbbbb bbbbbbP ", "pbbbbbbPbbbbbbp ", "pb           bp ", "pb           bp ", "pb           bp ", "pb           bp ", "pg           gp ", "pg           gp ", "pg           gp ", "pg           gp ", "pg           gp ", "pg           gp ", "pg           gp ", "pg           gp ", "pgggggggggggggp ", "P             P "};
    private static String[] Level12 = new String[]{"Pbbbbbb bbbbbbP ", "bbbbbbbPbbbbbbb ", "bb           bb ", "bb           bb ", "bb           bb ", "bb           bb ", "bg           gb ", "bg           gb ", "bg           gb ", "bg           gb ", "bg           gb ", "bg           gb ", "bg           gb ", "bg           gb ", " ggggggggggggg  ", "                "};
    private static String[] Level13 = new String[]{"Pbbbbbb bbbbbbP ", "bbbbbbbPbbbbbbb ", "Xb           bX ", "Xb           bX ", "Xb           bX ", "bb           bb ", "bg           gb ", "bg           gb ", "bg           gb ", "bg           gb ", "bg           gb ", "bg           gb ", " g           g  ", " g           g  ", " ggggggggggggg  ", "                "};
    private static String[] Level14 = new String[]{"Pbbbbbb bbbbbbP ", "bbbbbbbPbbbbbbb ", "bb           bb ", "bb           bb ", "bb           bb ", "bb           bb ", "bg           gb ", "bg           gb ", "bg           gb ", "bg           gb ", " g           g  ", " g           g  ", " g           g  ", " g           g  ", " ggggggggggggg  ", "                "};
    private static String[] Level15 = new String[]{"Pbbbbbb bbbbbbP ", "pbbbbbbPbbbbbbp ", "pb           bp ", "pb           bp ", "pb           bp ", "pb           bp ", "pg           gp ", "pg           gp ", " g           g  ", " g           g  ", " g           g  ", " g           g  ", " g           g  ", " g           g  ", " ggggggggggggg  ", "                "};
    private static String[] Level16 = new String[]{"                ", " bbbbbbPbbbbbb  ", " b           b  ", " b           b  ", " b           b  ", " b           b  ", " g           g  ", " g           g  ", " g           g  ", " g           g  ", " g           g  ", " g           g  ", " g           g  ", " g           g  ", " ggggggggggggg  ", "                "};
    private static String[] Level17_and_19 = new String[]{"bbbbbbb bbbbbbb ", "bbbbbbbPbbbbbbb ", "bbBBBBBBBBBBBbb ", "bbBBBBBBBBBBBbb ", "bbBBBBBBBBBBBbb ", "bbBBBBBBBBBBBbb ", "bbBBBBBBBBBBBbb ", "bbBBBBBBBBBBBbb ", "bbBBBBBBBBBBBbb ", "bbBBBBBBBBBBBbb ", "bbBBBBBBBBBBBbb ", "bbBBBBBBBBBBBbb ", "bbBBBBBBBBBBBbb ", "bbBBBBBBBBBBBbb ", "bgggggggggggggb ", "bbbbbbbbbbbbbbb "};
    private static String[] Level18 = new String[]{"                ", " ppppppPpppppp  ", " pBBBBBBBBBBBp  ", " pBBBBBBBBBBBp  ", " pBBBBBBBBBBBp  ", " pBBBBBBBBBBBp  ", " pBBBBBBBBBBBp  ", " pBBBBBBBBBBBp  ", " pBBBBBBBBBBBp  ", " pBBBBBBBBBBBp  ", " pBBBBBBBBBBBp  ", " pBBBBBBBBBBBp  ", " pBBBBBBBBBBBp  ", " pBBBBBBBBBBBp  ", " ppppppppppppp  ", "                "};
    private static String[] Level20_25 = new String[]{"                ", " gggggbPbggggg  ", " g           g  ", " g           g  ", " g           g  ", " g           g  ", " g           g  ", " g           g  ", " g           g  ", " g           g  ", " g           g  ", " g           g  ", " g           g  ", " g           g  ", " ggggggggggggg  ", "                "};
    private static String[] LevelH1 = new String[]{"                ", " gggggbPbggggg  ", " ggggggggggggg  ", " ggggggggggggg  ", " ggggggggggggg  ", " ggggggggggggg  ", " ggggggggggggg  ", " ggggggggggggg  ", " ggggggggggggg  ", " ggggggggggggg  ", " ggggggggggggg  ", " ggggggggggggg  ", " ggggggggggggg  ", " ggggggggggggg  ", " ggggggggggggg  ", "                "};
    private static String[] LevelH2 = new String[]{"                ", "      bPb       ", "      bPb       ", "      bPb       ", "      bbb       ", "                ", "                ", "                ", "                ", "                ", "                ", "                ", "                ", "                ", "                ", "                "};
    private static String[][] LEVEL = new String[][]{LevelBase, Level1_3, Level1_3, Level1_3, Level4, Level5_6, Level5_6, Level7, Level8_9, Level8_9, Level10, Level11, Level12, Level13, Level14, Level15, Level16, Level17_and_19, Level18, Level17_and_19, Level20_25, Level20_25, Level20_25, Level20_25, Level20_25, Level20_25, Level17_and_19, Level18, Level17_and_19, Level20_25, Level20_25, Level20_25, Level20_25, Level20_25, Level20_25, Level17_and_19, Level18, Level17_and_19, Level20_25, Level20_25, Level20_25, Level20_25, Level20_25, Level20_25, Level20_25, Level20_25, Level20_25, Level20_25, Level20_25, Level20_25, LevelH1, LevelH2};

    public MapGenRuinedCities(GenericChunkGenerator provider) {
        this.provider = provider;
    }

    public Span findSuitableY(int x, int z, Block[] ablock) {
        int index = (x * 16 + z) * 256;
        Span bestSpan = null;
        int lowestNonair = 256;
        for (int y = 255; y >= 0; --y) {
            Block block = ablock[index + y];
            if (block == null || block.func_149688_o(block.func_176223_P()) == Material.field_151579_a || block == Blocks.field_150357_h) continue;
            if (bestSpan == null || bestSpan.isLarger(y + 1, lowestNonair - 1)) {
                bestSpan = new Span(y + 1, lowestNonair - 1);
            }
            lowestNonair = y;
        }
        if (bestSpan == null) {
            bestSpan = Span.EMPTY;
        }
        return bestSpan;
    }

    private Span findSuitableSpan(Block[] ablock) {
        Span s1 = this.findSuitableY(0, 0, ablock);
        if (s1.isEmpty()) {
            return null;
        }
        Span s = new Span(s1);
        Span s2 = this.findSuitableY(15, 0, ablock);
        if ((s = s.intersect(s2)).isEmpty()) {
            return null;
        }
        Span s3 = this.findSuitableY(0, 15, ablock);
        if ((s = s.intersect(s3)).isEmpty()) {
            return null;
        }
        Span s4 = this.findSuitableY(15, 15, ablock);
        if ((s = s.intersect(s4)).isEmpty()) {
            return null;
        }
        if (s.getHeight() < 40) {
            return null;
        }
        return Span.averageSpan(s1, s2, s3, s4);
    }

    public void generate(World world, int chunkX, int chunkZ, Block[] ablock, byte[] ameta) {
        Random random = new Random((world.func_72905_C() + (long)chunkX) * 117L + (long)(chunkZ * 36631) + 177L);
        random.nextFloat();
        if (random.nextFloat() > 0.1f) {
            return;
        }
        Span span = this.findSuitableSpan(ablock);
        if (span == null) {
            return;
        }
        this.createBuilding(ablock, ameta, span);
    }

    private void createBlockMap() {
        if (blockMap != null) {
            return;
        }
        blockMap = new HashMap<Character, IBlockState>();
        blockMap.put(Character.valueOf(' '), null);
        blockMap.put(Character.valueOf('B'), ModBlocks.dimensionalBlock.func_176223_P());
        blockMap.put(Character.valueOf('b'), ModBlocks.dimensionalBlankBlock.func_176223_P());
        blockMap.put(Character.valueOf('p'), ModBlocks.dimensionalCrossBlock.func_176223_P().func_177226_a((IProperty)AbstractDirectionalBlock.FACING, (Comparable)EnumFacing.NORTH));
        blockMap.put(Character.valueOf('P'), ModBlocks.dimensionalCrossBlock.func_176223_P());
        blockMap.put(Character.valueOf('X'), ModBlocks.dimensionalPattern1Block.func_176223_P());
        blockMap.put(Character.valueOf('x'), ModBlocks.dimensionalPattern2Block.func_176223_P());
        blockMap.put(Character.valueOf('g'), Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)EnumDyeColor.BLUE));
    }

    private void createBuilding(Block[] ablock, byte[] ameta, Span span) {
        this.createBlockMap();
        int idx = 0;
        for (int y = span.low - 1; y <= span.high; ++y) {
            if (idx >= LEVEL.length) {
                return;
            }
            String[] level = LEVEL[idx++];
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int index = (x * 16 + z) * 256 + y;
                    char c = level[z].charAt(x);
                    IBlockState blockMeta = blockMap.get(Character.valueOf(c));
                    if (blockMeta == null) continue;
                    ablock[index] = blockMeta.func_177230_c();
                    ameta[index] = (byte)blockMeta.func_177230_c().func_176201_c(blockMeta);
                }
            }
        }
    }

    private static class Span {
        private final int low;
        private final int high;
        public static final Span EMPTY = new Span(0, -1);

        public Span(int low, int high) {
            this.low = low;
            this.high = high;
        }

        public Span(Span other) {
            this(other.low, other.high);
        }

        public boolean isEmpty() {
            return this.low > this.high;
        }

        public boolean isLarger(int ylow, int yhigh) {
            return yhigh - ylow > this.high - this.low;
        }

        public int getHeight() {
            return this.high - this.low + 1;
        }

        public Span intersect(Span other) {
            if (this.isEmpty() || other.isEmpty()) {
                return EMPTY;
            }
            if (this.low > other.high) {
                return EMPTY;
            }
            if (this.high < other.low) {
                return EMPTY;
            }
            return new Span(Math.max(this.low, other.low), Math.min(this.high, other.high));
        }

        public static Span averageSpan(Span ... spans) {
            int size = spans.length;
            int low = 0;
            int high = 0;
            for (Span span : spans) {
                low += span.low;
                high += span.high;
            }
            return new Span(low / size, high / size);
        }
    }
}

