/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.thirteen.Context;
import mcjty.rftoolsdim.dimensions.DimensionStorage;
import mcjty.rftoolsdim.network.PacketReturnEnergy;
import mcjty.rftoolsdim.network.RFToolsDimMessages;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketGetDimensionEnergy
implements IMessage {
    private int dimension;

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
    }

    public PacketGetDimensionEnergy() {
    }

    public PacketGetDimensionEnergy(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketGetDimensionEnergy(int dimension) {
        this.dimension = dimension;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            World world = ctx.getSender().func_130014_f_();
            DimensionStorage dimensionStorage = DimensionStorage.getDimensionStorage(world);
            PacketReturnEnergy returnMessage = new PacketReturnEnergy(this.dimension, dimensionStorage.getEnergyLevel(this.dimension));
            RFToolsDimMessages.INSTANCE.sendTo((IMessage)returnMessage, ctx.getSender());
        });
        ctx.setPacketHandled(true);
    }
}

