/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.tr7zw.skinlayers.Config;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.config.CustomConfigScreen;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SkinLayersModBase {
    public static SkinLayersModBase instance;
    public static final Logger LOGGER;
    public static Config config;
    private File settingsFile = new File("config", "skinlayers.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public void onInitialize() {
        instance = this;
        if (this.settingsFile.exists()) {
            try {
                config = (Config)new Gson().fromJson(new String(Files.readAllBytes(this.settingsFile.toPath()), StandardCharsets.UTF_8), Config.class);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (config == null) {
            config = new Config();
            this.writeConfig();
        }
    }

    public void writeConfig() {
        if (this.settingsFile.exists()) {
            this.settingsFile.delete();
        }
        try {
            Files.write(this.settingsFile.toPath(), this.gson.toJson((Object)config).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void refreshLayers(EntityPlayer player) {
        if (player == null || !(player instanceof PlayerSettings)) {
            return;
        }
        PlayerSettings settings = (PlayerSettings)player;
        settings.setupSkinLayers(null);
        settings.setupHeadLayers(null);
    }

    static {
        LOGGER = LogManager.getLogger();
        config = null;
    }

    public static class ConfigScreen
    extends CustomConfigScreen {
        private Minecraft minecraft = Minecraft.func_71410_x();

        public ConfigScreen(GuiScreen lastScreen) {
            super(lastScreen, "text.skinlayers.title");
        }

        @Override
        public void initialize() {
            ArrayList<GuiButton> options = new ArrayList<GuiButton>();
            options.add(this.getOnOffOption("text.skinlayers.enable.hat", () -> SkinLayersModBase.config.enableHat, b -> {
                SkinLayersModBase.config.enableHat = b;
            }));
            options.add(this.getOnOffOption("text.skinlayers.enable.jacket", () -> SkinLayersModBase.config.enableJacket, b -> {
                SkinLayersModBase.config.enableJacket = b;
            }));
            options.add(this.getOnOffOption("text.skinlayers.enable.leftsleeve", () -> SkinLayersModBase.config.enableLeftSleeve, b -> {
                SkinLayersModBase.config.enableLeftSleeve = b;
            }));
            options.add(this.getOnOffOption("text.skinlayers.enable.rightsleeve", () -> SkinLayersModBase.config.enableRightSleeve, b -> {
                SkinLayersModBase.config.enableRightSleeve = b;
            }));
            options.add(this.getOnOffOption("text.skinlayers.enable.leftpants", () -> SkinLayersModBase.config.enableLeftPants, b -> {
                SkinLayersModBase.config.enableLeftPants = b;
            }));
            options.add(this.getOnOffOption("text.skinlayers.enable.rightpants", () -> SkinLayersModBase.config.enableRightPants, b -> {
                SkinLayersModBase.config.enableRightPants = b;
            }));
            options.add(this.getIntOption("text.skinlayers.renderdistancelod", 5.0f, 40.0f, () -> SkinLayersModBase.config.renderDistanceLOD, i -> {
                SkinLayersModBase.config.renderDistanceLOD = i;
            }));
            options.add(this.getDoubleOption("text.skinlayers.basevoxelsize", 1.001f, 1.4f, 0.001f, () -> SkinLayersModBase.config.baseVoxelSize, i -> {
                SkinLayersModBase.config.baseVoxelSize = i.floatValue();
                instance.refreshLayers((EntityPlayer)this.minecraft.field_71439_g);
            }));
            options.add(this.getDoubleOption("text.skinlayers.headvoxelsize", 1.001f, 1.25f, 0.001f, () -> SkinLayersModBase.config.headVoxelSize, i -> {
                SkinLayersModBase.config.headVoxelSize = i.floatValue();
                instance.refreshLayers((EntityPlayer)this.minecraft.field_71439_g);
            }));
            options.add(this.getDoubleOption("text.skinlayers.bodyvoxelwidthsize", 1.001f, 1.4f, 0.001f, () -> SkinLayersModBase.config.bodyVoxelWidthSize, i -> {
                SkinLayersModBase.config.bodyVoxelWidthSize = i.floatValue();
                instance.refreshLayers((EntityPlayer)this.minecraft.field_71439_g);
            }));
            options.add(this.getOnOffOption("text.skinlayers.skulls.enable", () -> SkinLayersModBase.config.enableSkulls, b -> {
                SkinLayersModBase.config.enableSkulls = b;
            }));
            options.add(this.getOnOffOption("text.skinlayers.skullsitems.enable", () -> SkinLayersModBase.config.enableSkullsItems, b -> {
                SkinLayersModBase.config.enableSkullsItems = b;
            }));
            options.add(this.getDoubleOption("text.skinlayers.skulls.voxelsize", 1.001f, 1.2f, 0.001f, () -> SkinLayersModBase.config.skullVoxelSize, i -> {
                SkinLayersModBase.config.skullVoxelSize = i.floatValue();
            }));
            options.add(this.getOnOffOption("text.skinlayers.fastrender.enable", () -> SkinLayersModBase.config.fastRender, b -> {
                SkinLayersModBase.config.fastRender = b;
            }));
            this.addOptionsList(options);
        }

        @Override
        public void save() {
            instance.writeConfig();
        }

        @Override
        public void func_73863_a(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
            super.func_73863_a(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
            if (this.minecraft.field_71441_e != null) {
                int x = this.field_146294_l / 2;
                int y = this.field_146295_m - 45;
                int size = (int)(40.0f * ((float)this.field_146295_m / 200.0f));
                int lookX = x - p_drawScreen_1_;
                int lookY = y - 80 - p_drawScreen_2_;
                lookY = Math.min(lookY, 10);
                GlStateManager.func_179126_j();
                GuiInventory.func_147046_a((int)x, (int)y, (int)size, (float)lookX, (float)lookY, (EntityLivingBase)this.minecraft.field_71439_g);
            }
        }
    }
}

