/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.config;

import dev.tr7zw.skinlayers.config.GuiButtonRowList;
import dev.tr7zw.skinlayers.config.GuiEnumButton;
import dev.tr7zw.skinlayers.config.GuiSliderButton;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;

public abstract class CustomConfigScreen
extends GuiScreen {
    protected final GuiScreen lastScreen;
    protected String screenTitle = "Settings";
    private Map<GuiButton, Runnable> buttonActions = new HashMap<GuiButton, Runnable>();
    private GuiButtonRowList optionsRowList;

    public CustomConfigScreen(GuiScreen lastScreen, String title) {
        this.screenTitle = title;
        this.lastScreen = lastScreen;
    }

    public void func_73866_w_() {
        this.screenTitle = I18n.func_135052_a((String)this.screenTitle, (Object[])new Object[0]);
        this.field_146292_n.clear();
        this.buttonActions.clear();
        this.addButton(new GuiButton(200, this.field_146294_l / 2 - 100, this.field_146295_m - 27, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])), () -> this.onClose());
        this.initialize();
    }

    public void addOptionsList(List<GuiButton> options) {
        this.optionsRowList = new GuiButtonRowList(this.field_146297_k, this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 32, 25, options);
    }

    public void addButton(GuiButton button, Runnable action) {
        this.field_146292_n.add(button);
        this.buttonActions.put(button, action);
    }

    protected void func_146284_a(GuiButton p_actionPerformed_1_) throws IOException {
        if (!p_actionPerformed_1_.field_146124_l) {
            return;
        }
        this.buttonActions.get(p_actionPerformed_1_).run();
    }

    public void onClose() {
        this.save();
        this.field_146297_k.func_147108_a(this.lastScreen);
    }

    public abstract void initialize();

    public abstract void save();

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.optionsRowList.func_178039_p();
    }

    protected void func_73864_a(int p_mouseClicked_1_, int p_mouseClicked_2_, int p_mouseClicked_3_) throws IOException {
        super.func_73864_a(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        this.optionsRowList.func_148179_a(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
    }

    protected void func_146286_b(int p_mouseReleased_1_, int p_mouseReleased_2_, int p_mouseReleased_3_) {
        super.func_146286_b(p_mouseReleased_1_, p_mouseReleased_2_, p_mouseReleased_3_);
        this.optionsRowList.func_148181_b(p_mouseReleased_1_, p_mouseReleased_2_, p_mouseReleased_3_);
    }

    public void func_73863_a(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.func_146276_q_();
        this.optionsRowList.func_148128_a(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
        this.func_73732_a(this.field_146289_q, this.screenTitle, this.field_146294_l / 2, 5, 0xFFFFFF);
        super.func_73863_a(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }

    public GuiButton getDoubleOption(String translationKey, float min, float max, float steps, Supplier<Double> current, Consumer<Double> update) {
        GuiSliderButton slider = new GuiSliderButton(translationKey, min, max, steps, current, update);
        return slider;
    }

    public GuiButton getIntOption(String translationKey, float min, float max, Supplier<Integer> current, Consumer<Integer> update) {
        GuiSliderButton slider = new GuiSliderButton(translationKey, min, max, 1.0f, () -> (double)((Integer)current.get()), d -> update.accept(d.intValue()));
        return slider;
    }

    public <T extends Enum> GuiButton getEnumOption(String translationKey, Class<T> targetEnum, Supplier<T> current, Consumer<T> update) {
        GuiEnumButton<T> button = new GuiEnumButton<T>(translationKey, translationKey, targetEnum, current, update);
        return button;
    }

    public GuiButton getOnOffOption(String translationKey, Supplier<Boolean> current, Consumer<Boolean> update) {
        GuiEnumButton<OnOff> button = new GuiEnumButton<OnOff>(translationKey, "text.skinlayers.boolean", OnOff.class, () -> (Boolean)current.get() != false ? OnOff.ON : OnOff.OFF, e -> update.accept(e == OnOff.ON));
        return button;
    }

    public static enum OnOff {
        ON,
        OFF;

    }
}

