/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration;

import appeng.integration.IIntegrationModule;
import appeng.integration.IntegrationSide;
import appeng.integration.Integrations;
import appeng.integration.modules.crafttweaker.CTModule;
import appeng.integration.modules.ic2.IC2Module;
import appeng.integration.modules.inventorytweaks.InventoryTweaksModule;
import appeng.integration.modules.jei.JEIModule;
import appeng.integration.modules.theoneprobe.TheOneProbeModule;
import appeng.integration.modules.waila.WailaModule;

public enum IntegrationType {
    IC2(IntegrationSide.BOTH, "Industrial Craft 2", "ic2"){

        @Override
        public IIntegrationModule createInstance() {
            return Integrations.setIc2(new IC2Module());
        }
    }
    ,
    RC(IntegrationSide.BOTH, "Railcraft", "railcraft"),
    MFR(IntegrationSide.BOTH, "Mine Factory Reloaded", "minefactoryreloaded"),
    Waila(IntegrationSide.BOTH, "Waila", "waila"){

        @Override
        public IIntegrationModule createInstance() {
            return new WailaModule();
        }
    }
    ,
    InvTweaks(IntegrationSide.CLIENT, "Inventory Tweaks", "inventorytweaks"){

        @Override
        public IIntegrationModule createInstance() {
            return Integrations.setInvTweaks(new InventoryTweaksModule());
        }
    }
    ,
    JEI(IntegrationSide.CLIENT, "Just Enough Items", "jei"){

        @Override
        public IIntegrationModule createInstance() {
            return Integrations.setJei(new JEIModule());
        }
    }
    ,
    Mekanism(IntegrationSide.BOTH, "Mekanism", "mekanism"),
    OpenComputers(IntegrationSide.BOTH, "OpenComputers", "opencomputers"),
    THE_ONE_PROBE(IntegrationSide.BOTH, "TheOneProbe", "theoneprobe"){

        @Override
        public IIntegrationModule createInstance() {
            return new TheOneProbeModule();
        }
    }
    ,
    TESLA(IntegrationSide.BOTH, "Tesla", "tesla"),
    CRAFTTWEAKER(IntegrationSide.BOTH, "CraftTweaker", "crafttweaker"){

        @Override
        public IIntegrationModule createInstance() {
            return new CTModule();
        }
    };

    public final IntegrationSide side;
    public final String dspName;
    public final String modID;

    private IntegrationType(IntegrationSide side, String name, String modid) {
        this.side = side;
        this.dspName = name;
        this.modID = modid;
    }

    public IIntegrationModule createInstance() {
        return new IIntegrationModule(){};
    }
}

