/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import java.util.Objects;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.UndisableableConfigException;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;

public abstract class ConfigurableTypeAction<C extends ExtendedConfig<C>> {
    public void commonRun(C eConfig, Configuration config) {
        if (((ExtendedConfig)eConfig).isDisableable()) {
            this.preRun(eConfig, config, true);
        }
        if (((ExtendedConfig)eConfig).isEnabled()) {
            this.postRun(eConfig, config);
        } else {
            if (!((ExtendedConfig)eConfig).isDisableable()) {
                throw new UndisableableConfigException((ExtendedConfig<?>)eConfig);
            }
            this.onSkipRegistration(eConfig);
        }
    }

    protected void onSkipRegistration(C eConfig) {
        ((ExtendedConfig)eConfig).getMod().log(Level.TRACE, "Skipped registering " + ((ExtendedConfig)eConfig).getNamedId());
    }

    public abstract void preRun(C var1, Configuration var2, boolean var3);

    public abstract void postRun(C var1, Configuration var2);

    public void polish(C config) {
    }

    public static <T extends IForgeRegistryEntry<T>> void register(T instance, ExtendedConfig<?> config) {
        ConfigurableTypeAction.register(instance, config, () -> {
            config.onForgeRegistered();
            return null;
        });
    }

    public static <T extends IForgeRegistryEntry<T>> void register(T instance, ExtendedConfig<?> config, @Nullable Callable<?> callback) {
        ConfigurableTypeAction.register(Objects.requireNonNull(config.getRegistry(), "Tried registering a config for which no registry exists: " + config.getNamedId()), instance, config, callback);
    }

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, T instance, ExtendedConfig<?> config) {
        ConfigurableTypeAction.register(registry, instance, config, null);
    }

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, T instance, ExtendedConfig<?> config, @Nullable Callable<?> callback) {
        if (instance.getRegistryName() == null) {
            instance.setRegistryName(new ResourceLocation(config.getMod().getModId(), config.getNamedId()));
        }
        config.getMod().getConfigHandler().registerToRegistry(registry, instance, callback);
    }
}

