/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat.capabilities;

import java.util.Objects;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class MultipleCapabilityProvider
implements ICapabilityProvider {
    private final Capability<?>[] capabilityTypes;
    private final Object[] capabilities;

    public MultipleCapabilityProvider(Capability<?>[] capabilityTypes, Object[] capabilities) {
        assert (capabilityTypes.length == capabilities.length);
        this.capabilityTypes = Objects.requireNonNull(capabilityTypes);
        this.capabilities = Objects.requireNonNull(capabilities);
    }

    protected int getCapabilityId(Capability<?> capability) {
        for (int i = 0; i < this.capabilityTypes.length; ++i) {
            Capability<?> capabilityType = this.capabilityTypes[i];
            if (capabilityType != capability) continue;
            return i;
        }
        return -1;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.getCapabilityId(capability) >= 0;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        Object[] objectArray;
        int n;
        int n2;
        int capabilityId = this.getCapabilityId(capability);
        if (capabilityId >= 0 && (n2 = 0) < (n = (objectArray = this.capabilities).length)) {
            Object o = objectArray[n2];
            return (T)this.capabilities[capabilityId];
        }
        return null;
    }

    public static <T1, T2> MultipleCapabilityProvider of(Capability<T1> capabilityType1, T1 capability1, Capability<T2> capabilityType2, T2 capability2) {
        return new MultipleCapabilityProvider(new Capability[]{capabilityType1, capabilityType2}, new Object[]{capability1, capability2});
    }

    public static <T1, T2, T3> MultipleCapabilityProvider of(Capability<T1> capabilityType1, T1 capability1, Capability<T2> capabilityType2, T2 capability2, Capability<T3> capabilityType3, T3 capability3) {
        return new MultipleCapabilityProvider(new Capability[]{capabilityType1, capabilityType2, capabilityType3}, new Object[]{capability1, capability2, capability3});
    }
}

