/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import com.google.common.collect.Sets;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IValueTypeVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.item.ValueTypeVariableFacade;
import org.cyclops.integrateddynamics.core.tileentity.TileActiveVariableBase;
import org.cyclops.integrateddynamics.network.MaterializerNetworkElement;

public class TileMaterializer
extends TileActiveVariableBase<MaterializerNetworkElement> {
    public static final int SLOT_READ = 0;
    public static final int SLOT_WRITE_IN = 1;
    public static final int SLOT_WRITE_OUT = 2;
    private EntityPlayer lastPlayer = null;

    public TileMaterializer() {
        super(3, "materializer");
        this.addSlotsToSide(EnumFacing.UP, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.DOWN, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.SOUTH, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.WEST, Sets.newHashSet((Object[])new Integer[]{2}));
        this.addSlotsToSide(EnumFacing.EAST, Sets.newHashSet((Object[])new Integer[]{1}));
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(World world, BlockPos blockPos) {
                return new MaterializerNetworkElement(DimPos.of((World)world, (BlockPos)blockPos));
            }
        });
    }

    public boolean func_180462_a(int slot, ItemStack itemStack, EnumFacing side) {
        return slot != 2 && super.func_180462_a(slot, itemStack, side);
    }

    @Override
    public int getSlotRead() {
        return 0;
    }

    protected boolean canWrite() {
        IPartNetwork partNetwork = NetworkHelpers.getPartNetwork(this.getNetwork());
        return partNetwork != null && this.getVariable(partNetwork) != null && this.getEvaluator().getErrors().isEmpty();
    }

    @Override
    public void onDirty() {
        ItemStack outputStack;
        super.onDirty();
        if (!this.field_145850_b.field_72995_K && !this.func_70301_a(1).func_190926_b() && this.canWrite() && this.func_70301_a(2).func_190926_b() && !(outputStack = this.writeMaterialized(!this.func_145831_w().field_72995_K, this.func_70301_a(1))).func_190926_b()) {
            this.func_70299_a(2, outputStack);
            this.func_70304_b(1);
        }
    }

    public ItemStack writeMaterialized(boolean generateId, ItemStack itemStack) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        IVariable<?> variable = this.getVariable(NetworkHelpers.getPartNetwork(this.getNetwork()));
        try {
            final Object value = variable.getType().materialize(variable.getValue());
            final IValueType valueType = value.getType();
            return registry.writeVariableFacadeItem(generateId, itemStack, ValueTypes.REGISTRY, new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IValueTypeVariableFacade>(){

                @Override
                public IValueTypeVariableFacade create(boolean generateId) {
                    return new ValueTypeVariableFacade<IValue>(generateId, valueType, value);
                }

                @Override
                public IValueTypeVariableFacade create(int id) {
                    return new ValueTypeVariableFacade<IValue>(id, valueType, value);
                }
            }, this.lastPlayer, (Block)this.getBlock());
        }
        catch (EvaluationException e) {
            this.getEvaluator().addError(new L10NHelpers.UnlocalizedString(e.getMessage(), new Object[0]));
            return ItemStack.field_190927_a;
        }
    }

    public void setLastPlayer(EntityPlayer lastPlayer) {
        this.lastPlayer = lastPlayer;
    }
}

