/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import java.util.ArrayList;
import java.util.List;
import jds.bibliocraft.blocks.BiblioLightBlock;
import jds.bibliocraft.helpers.EnumMetalType;
import jds.bibliocraft.helpers.EnumVertPosition;
import jds.bibliocraft.tileentities.BiblioLightTileEntity;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockLampGold
extends BiblioLightBlock {
    public static String name = "LampGold";
    public static BlockLampGold instance = new BlockLampGold();

    public BlockLampGold() {
        super(name);
    }

    @Override
    public List<String> getModelParts(BiblioTileEntity tile) {
        ArrayList<String> modelParts = new ArrayList<String>();
        switch (tile.getVertPosition()) {
            case CEILING: {
                modelParts.add("ceilingPlate");
                modelParts.add("lampTopCeiling");
                break;
            }
            case WALL: {
                modelParts.add("wallPlate");
                modelParts.add("lampTopWall");
                break;
            }
            case FLOOR: {
                modelParts.add("baseFloor");
                modelParts.add("lampTopFloor");
            }
        }
        return modelParts;
    }

    @Override
    public void additionalLightPlacmentCommands(BiblioTileEntity biblioTile) {
        if (biblioTile instanceof BiblioLightTileEntity) {
            BiblioLightTileEntity light = (BiblioLightTileEntity)biblioTile;
            light.setLightType(EnumMetalType.GOLD);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        AxisAlignedBB output = this.getBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        TileEntity pretile = blockAccess.func_175625_s(pos);
        if (pretile != null && pretile instanceof BiblioLightTileEntity) {
            BiblioLightTileEntity tile = (BiblioLightTileEntity)pretile;
            EnumVertPosition style = tile.getVertPosition();
            switch (style) {
                case FLOOR: {
                    output = this.getBlockBounds(0.18f, 0.0f, 0.18f, 0.82f, 1.0f, 0.82f);
                    break;
                }
                case WALL: {
                    output = this.getBlockBounds(0.1f, 0.05f, 0.1f, 0.9f, 0.55f, 0.9f);
                    break;
                }
                case CEILING: {
                    output = this.getBlockBounds(0.1f, 0.0f, 0.1f, 0.9f, 1.0f, 0.9f);
                    break;
                }
                default: {
                    output = this.getBlockBounds(0.18f, 0.0f, 0.18f, 0.82f, 1.0f, 0.82f);
                }
            }
        }
        return output;
    }
}

