/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.network.packet.client;

import io.netty.buffer.ByteBuf;
import jds.bibliocraft.helpers.BiblioRenderHelper;
import jds.bibliocraft.network.BiblioNetworking;
import jds.bibliocraft.network.packet.server.BiblioPaneler;
import jds.bibliocraft.tileentities.TileEntityFurniturePaneler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BiblioPanelerClient
implements IMessage {
    ItemStack panels;
    BlockPos pos;

    public BiblioPanelerClient() {
    }

    public BiblioPanelerClient(ItemStack panels, BlockPos pos) {
        this.panels = panels;
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        this.panels = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.panels);
        buf.writeLong(this.pos.func_177986_g());
    }

    public static class Handler
    implements IMessageHandler<BiblioPanelerClient, IMessage> {
        public IMessage onMessage(BiblioPanelerClient message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                TileEntity tile;
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                String panelTextureName = "none";
                if (message.panels != ItemStack.field_190927_a) {
                    panelTextureName = BiblioRenderHelper.getBlockTextureString(message.panels);
                }
                if ((tile = player.field_70170_p.func_175625_s(message.pos)) != null && tile instanceof TileEntityFurniturePaneler) {
                    TileEntityFurniturePaneler paneler = (TileEntityFurniturePaneler)tile;
                    paneler.setCustomCraftingTex(panelTextureName);
                }
                BiblioNetworking.INSTANCE.sendToServer((IMessage)new BiblioPaneler(panelTextureName, message.pos));
            });
            return null;
        }
    }
}

