/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.network.packet.server;

import io.netty.buffer.ByteBuf;
import jds.bibliocraft.network.packet.Utils;
import jds.bibliocraft.tileentities.TileEntityPaintPress;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BiblioPaintPress
implements IMessage {
    BlockPos pos;
    int artType;
    String artName;
    boolean applyToCanvas;

    public BiblioPaintPress() {
    }

    public BiblioPaintPress(BlockPos pos, int artType, String artName, boolean applyToCanvas) {
        this.pos = pos;
        this.artType = artType;
        this.artName = artName;
        this.applyToCanvas = applyToCanvas;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.artType = buf.readInt();
        this.artName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.applyToCanvas = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.artType);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.artName);
        buf.writeBoolean(this.applyToCanvas);
    }

    public static class Handler
    implements IMessageHandler<BiblioPaintPress, IMessage> {
        public IMessage onMessage(BiblioPaintPress message, MessageContext ctx) {
            World world;
            TileEntity tile;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (Utils.hasPointLoaded(player, message.pos) && (tile = (world = player.field_70170_p).func_175625_s(message.pos)) != null && tile instanceof TileEntityPaintPress) {
                TileEntityPaintPress press = (TileEntityPaintPress)tile;
                press.setSelectedPainting(message.artType, message.artName);
                if (message.applyToCanvas) {
                    press.setCycle(true);
                }
            }
            return null;
        }
    }
}

