/*
 * Decompiled with CFR 0.152.
 */
package io.socol.betterthirdperson;

import io.socol.betterthirdperson.api.config.CustomCameraConfig;
import io.socol.betterthirdperson.api.config.DefaultCustomCameraConfig;
import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CustomCameraConfigImpl
implements CustomCameraConfig {
    private final Configuration cfg;
    private boolean aimPlayerOnInteract;
    private int followYaw;
    private boolean freeCameraDuringElytraFlight;
    private int aimDuration;
    private boolean skipThirdPersonFrontView;
    private int pitchChangeSpeed;
    private int playerRotationSpeed;

    public CustomCameraConfigImpl(File configFile) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.cfg = new Configuration(configFile);
        this.syncConfig();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("betterthirdperson")) {
            this.syncConfig();
        }
    }

    private void syncConfig() {
        String category = "betterthirdperson";
        CustomCameraConfig def = DefaultCustomCameraConfig.INSTANCE;
        this.aimPlayerOnInteract = this.cfg.getBoolean("aimPlayerOnInteract", category, def.shouldAimPlayerOnInteract(), "Align player to camera on left & right clicks");
        this.freeCameraDuringElytraFlight = this.cfg.getBoolean("freeCameraDuringElytraFlight", category, def.hasFreeCameraDuringElytraFlight(), "Does camera should rotate freely during elytra flight");
        this.followYaw = this.cfg.getInt("followYaw", category, def.getFollowYaw(), 0, 90, "Angle in degrees within the player will slightly follow camera yaw (while standing still)");
        this.aimDuration = this.cfg.getInt("aimDuration", category, def.getAimDuration(), 10, 200, "How long player will be aligned to camera after left & right clicks");
        this.skipThirdPersonFrontView = this.cfg.getBoolean("skipThirdPersonFrontView", category, def.skipThirdPersonFrontView(), "Completely remove third-person front view");
        this.pitchChangeSpeed = this.cfg.getInt("pitchChangeSpeed", category, def.getPitchChangeSpeed(), 10, 100, "How fast player pitch follows camera pitch in third-person");
        this.playerRotationSpeed = this.cfg.getInt("playerRotationSpeed", category, def.getPlayerRotationSpeed(), 10, 100, "How fast player changes movement direction in third-person");
        if (this.cfg.hasChanged()) {
            this.cfg.save();
        }
    }

    @Override
    public boolean shouldAimPlayerOnInteract() {
        return this.aimPlayerOnInteract;
    }

    @Override
    public int getAimDuration() {
        return this.aimDuration;
    }

    @Override
    public int getFollowYaw() {
        return this.followYaw;
    }

    @Override
    public boolean hasFreeCameraDuringElytraFlight() {
        return this.freeCameraDuringElytraFlight;
    }

    @Override
    public boolean skipThirdPersonFrontView() {
        return this.skipThirdPersonFrontView;
    }

    @Override
    public int getPlayerRotationSpeed() {
        return this.playerRotationSpeed;
    }

    @Override
    public int getPitchChangeSpeed() {
        return this.pitchChangeSpeed;
    }
}

