/*
 * Decompiled with CFR 0.152.
 */
package io.socol.betterthirdperson;

import io.socol.betterthirdperson.api.CustomCameraManager;
import io.socol.betterthirdperson.api.TickPhase;
import io.socol.betterthirdperson.impl.MovementInputAdapter;
import io.socol.betterthirdperson.impl.PlayerAdapter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CustomCameraListener {
    private final CustomCameraManager manager;

    public CustomCameraListener(CustomCameraManager manager) {
        this.manager = manager;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof EntityPlayerSP) {
            PlayerAdapter player = new PlayerAdapter((EntityPlayerSP)event.player);
            TickPhase phase = event.phase == TickEvent.Phase.START ? TickPhase.START : TickPhase.END;
            this.manager.onPlayerTick(player, phase);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onInputs(InputUpdateEvent event) {
        PlayerAdapter player = new PlayerAdapter(Minecraft.func_71410_x().field_71439_g);
        MovementInputAdapter inputs = new MovementInputAdapter(event.getMovementInput());
        this.manager.handleMovementInputs(player, inputs, TickPhase.END);
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (event.phase != TickEvent.Phase.START || player == null) {
            return;
        }
        PlayerAdapter playerAdapter = new PlayerAdapter(player);
        this.manager.onRenderTickStart(playerAdapter, event.renderTickTime);
    }
}

