/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.api.crafting;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.zeitheron.hammercore.api.crafting.AbstractRecipeRegistry;
import com.zeitheron.hammercore.api.crafting.INameableRecipe;
import com.zeitheron.hammercore.api.crafting.IRecipeContainer;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.util.ResourceLocation;

public class NamespacedRecipeRegistry<T extends INameableRecipe>
extends AbstractRecipeRegistry<T, NamespacedRecipeContainer<T>, ResourceLocation> {
    public NamespacedRecipeRegistry(Class<T> type, ResourceLocation id) {
        super(type, new NamespacedRecipeContainer<T>(type), id);
    }

    @Override
    public ResourceLocation addRecipe(T recipe) {
        ResourceLocation loc = recipe.getRecipeName();
        if (loc == null) {
            throw new IllegalArgumentException("Attempted to register a recipe with null recipe name!");
        }
        if (((NamespacedRecipeContainer)this.container).elements.containsKey((Object)loc)) {
            throw new IllegalArgumentException("Attempted to register a recipe with registry name that is already taken!");
        }
        ((NamespacedRecipeContainer)this.container).elements.put((Object)loc, recipe);
        return loc;
    }

    @Override
    public void removeRecipe(T recipe) {
        ResourceLocation loc = (ResourceLocation)((NamespacedRecipeContainer)this.container).elementsInv.get(recipe);
        if (loc != null) {
            ((NamespacedRecipeContainer)this.container).remove(loc);
        }
    }

    @Override
    public T getRecipe(ResourceLocation identifier) {
        return (T)((INameableRecipe)((NamespacedRecipeContainer)this.container).elements.get((Object)identifier));
    }

    protected static class NamespacedRecipeContainer<T extends INameableRecipe>
    implements IRecipeContainer<T> {
        private final Class<T> type;
        private final BiMap<ResourceLocation, T> elements = HashBiMap.create();
        private final BiMap<T, ResourceLocation> elementsInv = this.elements.inverse();
        private final Collection<T> elementsView = Collections.unmodifiableCollection(this.elements.values());

        public NamespacedRecipeContainer(Class<T> type) {
            this.type = type;
        }

        @Override
        public Collection<T> getRecipes() {
            return this.elementsView;
        }

        @Override
        public Class<T> getType() {
            return this.type;
        }

        public void remove(ResourceLocation loc) {
            this.elements.remove((Object)loc);
        }
    }
}

