/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.particle.def.thunder;

import com.zeitheron.hammercore.client.particle.api.SimpleParticle;
import com.zeitheron.hammercore.client.particle.def.thunder.ThVector3;
import com.zeitheron.hammercore.client.particle.def.thunder.ThunderCore;
import com.zeitheron.hammercore.client.utils.UtilsFX;
import com.zeitheron.hammercore.net.internal.thunder.Thunder;
import com.zeitheron.hammercore.proxy.ParticleProxy_Client;
import com.zeitheron.hammercore.utils.color.ColorHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ThunderBoltParticle
extends SimpleParticle {
    private ThunderCore main;
    public Thunder.Layer core = new Thunder.Layer();
    public Thunder.Layer aura = new Thunder.Layer();

    public ThunderBoltParticle(World world, double x1, double y1, double z1, double x, double y, double z, long seed, int duration, float multi) {
        super(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.main = new ThunderCore(world, x1, y1, z1, x, y, z, seed, duration, multi, 1);
        this.setupFromMain();
    }

    public ThunderBoltParticle(World world, double x1, double y1, double z1, double x, double y, double z, long seed, int duration, float multi, int speed) {
        super(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.main = new ThunderCore(world, x1, y1, z1, x, y, z, seed, duration, multi, speed);
        this.setupFromMain();
    }

    public ThunderBoltParticle(World world, Entity detonator, Entity target, long seed) {
        super(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.main = new ThunderCore(world, detonator, target, seed);
        this.setupFromMain();
    }

    public ThunderBoltParticle(World world, Entity detonator, Entity target, long seed, int speed) {
        super(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.main = new ThunderCore(world, detonator, target, seed, speed);
        this.setupFromMain();
    }

    public ThunderBoltParticle(World world, ThVector3 jammervec, ThVector3 targetvec, long seed) {
        super(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.main = new ThunderCore(world, jammervec, targetvec, seed);
        this.setupFromMain();
    }

    public void defaultFractal() {
        this.main.defaultFractal();
    }

    public void defaultFractal(int splits, float baseAngle) {
        this.main.defaultFractal(splits, baseAngle);
    }

    @Override
    public void doRenderParticle(double x, double y, double z, float partialframe, float cosyaw, float cospitch, float sinyaw, float sinsinpitch, float cossinpitch) {
        int rgb;
        Entity renderentity = Minecraft.func_71410_x().func_175606_aa();
        int visibleDistance = 100;
        if (!Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            visibleDistance = 50;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        if (this.aura.active) {
            GL11.glBlendFunc((int)770, (int)this.aura.blendFunc);
            rgb = this.aura.color;
            this.field_70552_h = ColorHelper.getRed(rgb);
            this.field_70553_i = ColorHelper.getGreen(rgb);
            this.field_70551_j = ColorHelper.getBlue(rgb);
            UtilsFX.bindTexture("hammercore", "textures/misc/p_large.png");
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
            this.renderBolt(tessellator, partialframe, cosyaw, cospitch, sinyaw, cossinpitch, 0);
            tessellator.func_78381_a();
        }
        if (this.core.active) {
            GL11.glBlendFunc((int)770, (int)this.core.blendFunc);
            rgb = this.core.color;
            this.field_70552_h = ColorHelper.getRed(rgb);
            this.field_70553_i = ColorHelper.getGreen(rgb);
            this.field_70551_j = ColorHelper.getBlue(rgb);
            UtilsFX.bindTexture("hammercore", "textures/misc/p_small.png");
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
            this.renderBolt(tessellator, partialframe, cosyaw, cospitch, sinyaw, cossinpitch, 1);
            tessellator.func_78381_a();
        }
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
    }

    public void finalizeBolt() {
        this.main.finalizeBolt();
        this.setupFromMain();
        ParticleProxy_Client.queueParticleSpawn(this);
    }

    public void fractal(int splits, float amount, float splitchance, float splitlength, float splitangle) {
        this.main.fractal(splits, amount, splitchance, splitlength, splitangle);
    }

    public int getRenderPass() {
        return 2;
    }

    public void func_189213_a() {
        this.main.onUpdate();
        if (this.main.particleAge >= this.main.particleMaxAge) {
            this.func_187112_i();
        }
    }

    private void renderBolt(Tessellator tessellator, float partialframe, float cosyaw, float cospitch, float sinyaw, float cossinpitch, int pass) {
        BufferBuilder b = tessellator.func_178180_c();
        ThVector3 playervec = new ThVector3(sinyaw * -cospitch, -cossinpitch / cosyaw, cosyaw * cospitch);
        float boltage = this.main.particleAge >= 0 ? (float)(this.main.particleAge / this.main.particleMaxAge) : 0.0f;
        float mainalpha = 1.0f;
        mainalpha = pass == 0 ? (1.0f - boltage) * 0.4f : 1.0f - boltage * 0.5f;
        int renderlength = (int)(((float)this.main.particleAge + partialframe + (float)((int)(this.main.length * 3.0f))) / (float)((int)(this.main.length * 3.0f)) * (float)this.main.numsegments0);
        if (renderlength >= this.main.numsegments0) {
            float progress = 1.0f - ((float)this.main.particleAge + partialframe) / (float)this.main.particleMaxAge;
            mainalpha *= (progress *= 0.75f);
        }
        for (ThunderCore.Segment rendersegment : this.main.segments) {
            if (rendersegment.segmentno > renderlength) break;
            float width = 0.03f * (ThunderBoltParticle.getRelativeViewVector(rendersegment.startpoint.point).length() / 5.0f + 1.0f) * (1.0f + rendersegment.light) * 0.5f;
            ThVector3 diff1 = ThVector3.crossProduct(playervec, rendersegment.prevdiff).scale(width / rendersegment.sinprev);
            ThVector3 diff2 = ThVector3.crossProduct(playervec, rendersegment.nextdiff).scale(width / rendersegment.sinnext);
            ThVector3 startvec = rendersegment.startpoint.point;
            ThVector3 endvec = rendersegment.endpoint.point;
            float rx1 = (float)((double)startvec.x - Particle.field_70556_an);
            float ry1 = (float)((double)startvec.y - Particle.field_70554_ao);
            float rz1 = (float)((double)startvec.z - Particle.field_70555_ap);
            float rx2 = (float)((double)endvec.x - Particle.field_70556_an);
            float ry2 = (float)((double)endvec.y - Particle.field_70554_ao);
            float rz2 = (float)((double)endvec.z - Particle.field_70555_ap);
            b.func_181662_b((double)(rx2 - diff2.x), (double)(ry2 - diff2.y), (double)(rz2 - diff2.z)).func_187315_a(0.5, 0.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, mainalpha * rendersegment.light).func_181675_d();
            b.func_181662_b((double)(rx1 - diff1.x), (double)(ry1 - diff1.y), (double)(rz1 - diff1.z)).func_187315_a(0.5, 0.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, mainalpha * rendersegment.light).func_181675_d();
            b.func_181662_b((double)(rx1 + diff1.x), (double)(ry1 + diff1.y), (double)(rz1 + diff1.z)).func_187315_a(0.5, 1.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, mainalpha * rendersegment.light).func_181675_d();
            b.func_181662_b((double)(rx2 + diff2.x), (double)(ry2 + diff2.y), (double)(rz2 + diff2.z)).func_187315_a(0.5, 1.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, mainalpha * rendersegment.light).func_181675_d();
        }
    }

    public void setMultiplier(float m) {
        this.main.multiplier = m;
    }

    private void setupFromMain() {
        this.field_70547_e = this.main.particleMaxAge;
        this.func_187109_b(this.main.start.x, this.main.start.y, this.main.start.z);
    }

    private static ThVector3 getRelativeViewVector(ThVector3 pos) {
        Entity r = Minecraft.func_71410_x().func_175606_aa();
        return new ThVector3(r.field_70165_t - (double)pos.x, r.field_70163_u - (double)pos.y, r.field_70161_v - (double)pos.z);
    }
}

