/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.utils.texture.def;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.client.utils.IImagePreprocessor;
import com.zeitheron.hammercore.client.utils.texture.TexLocUploader;
import com.zeitheron.hammercore.lib.zlib.io.IOUtils;
import com.zeitheron.hammercore.lib.zlib.utils.Threading;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class ImagePuller {
    private static BufferedImage nosignal = null;
    public static ResourceLocation nosignal_gl = new ResourceLocation("hammercore", "textures/nosignal.png");
    public static final Map<String, Thread> DWN = new HashMap<String, Thread>();
    public static final Map<String, ResourceLocation> GL_IMAGES = new HashMap<String, ResourceLocation>();

    @Nullable
    public static BufferedImage noSignalBI() {
        if (nosignal == null) {
            try {
                nosignal = ImageIO.read(HammerCore.class.getResourceAsStream("/assets/hammercore/textures/nosignal.png"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return nosignal;
    }

    public static ResourceLocation getImageGL(String url, IImagePreprocessor ... proc) {
        if (url == null || url.isEmpty() || !url.toLowerCase().startsWith("http")) {
            return nosignal_gl;
        }
        if (DWN.get(url) != null) {
            return nosignal_gl;
        }
        if (GL_IMAGES.get(url) == null) {
            ImagePuller.download(url, proc);
        }
        return GL_IMAGES.getOrDefault(url, nosignal_gl);
    }

    public static boolean bind(String url, IImagePreprocessor ... proc) {
        ResourceLocation gl = ImagePuller.getImageGL(url, proc);
        if (gl != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(gl);
        }
        return gl != null;
    }

    private static void download(String url, IImagePreprocessor ... proc) {
        ResourceLocation rl = ImagePuller.getLocationForURL(url);
        HammerCore.LOG.info("Start download " + rl);
        DWN.put(url, Threading.createAndStart(() -> {
            BufferedImage img = IOUtils.downloadPicture(url);
            if (img == null) {
                img = ImagePuller.noSignalBI();
            } else {
                for (IImagePreprocessor p : proc) {
                    img = p.process(img);
                }
            }
            BufferedImage icon = img;
            Minecraft.func_71410_x().func_152344_a(() -> {
                TexLocUploader.upload(rl, icon);
                GL_IMAGES.put(url, rl);
            });
            DWN.remove(url);
        }));
    }

    public static ResourceLocation getLocationForURL(String url) {
        return new ResourceLocation("hammercore", url.substring(url.indexOf("://") + 3));
    }
}

