/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.internal;

import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.internal.chat.PacketDeleteMessage;
import com.zeitheron.hammercore.net.internal.chat.PacketEditMessage;
import com.zeitheron.hammercore.net.internal.chat.PacketSendMessage;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Chat {
    public static ChatFingerprint sendMessageAll(ITextComponent text) {
        return Chat.sendMessageTo(Objects::nonNull, text);
    }

    public static void sendMessageAll(ITextComponent text, ChatFingerprint print) {
        Chat.sendMessageTo(Objects::nonNull, text, print);
    }

    public static void editMessageForAll(ITextComponent text, ChatFingerprint print) {
        Chat.editMessageFor(Objects::nonNull, text, print);
    }

    public static void deleteMessageForAll(ChatFingerprint print) {
        Chat.deleteMessageFor(Objects::nonNull, print);
    }

    public static ChatFingerprint sendMessageTo(Predicate<EntityPlayerMP> player, ITextComponent text) {
        ChatFingerprint print = new ChatFingerprint();
        Chat.sendMessageTo(player, text, print);
        return print;
    }

    public static void sendMessageTo(Predicate<EntityPlayerMP> player, ITextComponent text, ChatFingerprint print) {
        MinecraftServer mcs = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (mcs != null) {
            mcs.func_184103_al().func_181057_v().stream().filter(player).forEach(mp -> HCNet.INSTANCE.sendTo(new PacketSendMessage().withPrint(print).withText(text), (EntityPlayerMP)mp));
        }
    }

    public static void editMessageFor(Predicate<EntityPlayerMP> player, ITextComponent text, ChatFingerprint print) {
        MinecraftServer mcs = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (mcs != null) {
            mcs.func_184103_al().func_181057_v().stream().filter(player).forEach(mp -> HCNet.INSTANCE.sendTo(new PacketEditMessage().withPrint(print).withText(text), (EntityPlayerMP)mp));
        }
    }

    public static void deleteMessageFor(Predicate<EntityPlayerMP> player, ChatFingerprint print) {
        MinecraftServer mcs = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (mcs != null) {
            mcs.func_184103_al().func_181057_v().stream().filter(player).forEach(mp -> HCNet.INSTANCE.sendTo(new PacketDeleteMessage().withPrint(print), (EntityPlayerMP)mp));
        }
    }

    public static ChatFingerprint sendMessageTo(EntityPlayerMP player, ITextComponent text) {
        ChatFingerprint print = new ChatFingerprint();
        HCNet.INSTANCE.sendTo(new PacketSendMessage().withPrint(print).withText(text), player);
        return print;
    }

    public static void editMessageFor(EntityPlayerMP player, ITextComponent text, ChatFingerprint print) {
        HCNet.INSTANCE.sendTo(new PacketEditMessage().withPrint(print).withText(text), player);
    }

    public static void deleteMessageFor(EntityPlayerMP player, ChatFingerprint print) {
        HCNet.INSTANCE.sendTo(new PacketDeleteMessage().withPrint(print), player);
    }

    @SideOnly(value=Side.CLIENT)
    public static void printNoSpam_client(long id, ITextComponent line) {
        ChatFingerprint fp = new ChatFingerprint(id);
        List rem = FingerprintedChatLine.getChatLines().stream().filter(l -> l instanceof FingerprintedChatLine).map(l -> (FingerprintedChatLine)((Object)l)).filter(l -> l.print.equals(fp)).collect(Collectors.toList());
        FingerprintedChatLine.getChatLines().removeAll(rem);
        Minecraft.func_71410_x().field_71456_v.func_146158_b().field_146253_i.removeAll(rem);
        new PacketEditMessage().withPrint(fp).withText(line).executeOnClient(null);
    }

    @SideOnly(value=Side.CLIENT)
    public static class FingerprintedChatLine
    extends ChatLine {
        public final ChatFingerprint print;
        public ITextComponent lineComponent;

        public FingerprintedChatLine(int updateCounterCreatedIn, ITextComponent lineStringIn, ChatFingerprint print) {
            super(updateCounterCreatedIn, lineStringIn, 0);
            this.lineComponent = lineStringIn;
            this.print = print;
        }

        public boolean isThisLine(ChatFingerprint print) {
            return Objects.equals(print, this.print);
        }

        public ITextComponent func_151461_a() {
            return this.lineComponent;
        }

        public void setLineComponent(ITextComponent lineComponent) {
            this.lineComponent = lineComponent;
        }

        @SideOnly(value=Side.CLIENT)
        public static List<ChatLine> getChatLines() {
            return Minecraft.func_71410_x().field_71456_v.func_146158_b().field_146252_h;
        }

        @SideOnly(value=Side.CLIENT)
        public static void deleteChatLine(ChatLine line) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().field_146253_i.remove(line);
            FingerprintedChatLine.getChatLines().remove(line);
        }

        @SideOnly(value=Side.CLIENT)
        public void add() {
            FingerprintedChatLine.getChatLines().add(0, this);
            Minecraft.func_71410_x().field_71456_v.func_146158_b().field_146253_i.add(0, this);
        }
    }

    public static class ChatFingerprint
    implements INBTSerializable<NBTTagCompound> {
        private static final Random RNG = new Random();
        public long l;

        public ChatFingerprint(long l) {
            this.l = l;
        }

        public ChatFingerprint(NBTTagCompound nbt) {
            this.deserializeNBT(nbt);
        }

        public ChatFingerprint() {
            this.l = RNG.nextLong();
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74772_a("N", this.l);
            return nbt;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.l = nbt.func_74763_f("N");
        }

        public boolean equals(Object obj) {
            return obj instanceof ChatFingerprint && ((ChatFingerprint)obj).l == this.l;
        }
    }
}

